/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.migration.streaming.runtime.streamrecord;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.migration.streaming.runtime.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class MultiplexingStreamRecordSerializer<T>
extends TypeSerializer<StreamElement> {
    private static final long serialVersionUID = 1L;
    private static final int TAG_REC_WITH_TIMESTAMP = 0;
    private static final int TAG_REC_WITHOUT_TIMESTAMP = 1;
    private static final int TAG_WATERMARK = 2;
    private final TypeSerializer<T> typeSerializer;

    public MultiplexingStreamRecordSerializer(TypeSerializer<T> serializer) {
        if (serializer instanceof MultiplexingStreamRecordSerializer || serializer instanceof StreamRecordSerializer) {
            throw new RuntimeException("StreamRecordSerializer given to StreamRecordSerializer as value TypeSerializer: " + serializer);
        }
        this.typeSerializer = Objects.requireNonNull(serializer);
    }

    public TypeSerializer<T> getContainedTypeSerializer() {
        return this.typeSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public MultiplexingStreamRecordSerializer<T> duplicate() {
        TypeSerializer copy = this.typeSerializer.duplicate();
        return copy == this.typeSerializer ? this : new MultiplexingStreamRecordSerializer<T>(copy);
    }

    public StreamRecord<T> createInstance() {
        return new StreamRecord<Object>(this.typeSerializer.createInstance());
    }

    public int getLength() {
        return -1;
    }

    public StreamElement copy(StreamElement from) {
        if (from.isRecord()) {
            StreamRecord fromRecord = from.asRecord();
            return fromRecord.copy(this.typeSerializer.copy(fromRecord.getValue()));
        }
        if (from.isWatermark()) {
            return from;
        }
        throw new RuntimeException();
    }

    public StreamElement copy(StreamElement from, StreamElement reuse) {
        if (from.isRecord() && reuse.isRecord()) {
            StreamRecord fromRecord = from.asRecord();
            StreamRecord reuseRecord = reuse.asRecord();
            Object valueCopy = this.typeSerializer.copy(fromRecord.getValue(), reuseRecord.getValue());
            fromRecord.copyTo(valueCopy, reuseRecord);
            return reuse;
        }
        if (from.isWatermark()) {
            return from;
        }
        throw new RuntimeException("Cannot copy " + from + " -> " + reuse);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        byte tag = source.readByte();
        target.write((int)tag);
        if (tag == 0) {
            target.writeLong(source.readLong());
            this.typeSerializer.copy(source, target);
        } else if (tag == 1) {
            this.typeSerializer.copy(source, target);
        } else if (tag == 2) {
            target.writeLong(source.readLong());
        } else {
            throw new IOException("Corrupt stream, found tag: " + tag);
        }
    }

    public void serialize(StreamElement value, DataOutputView target) throws IOException {
        if (value.isRecord()) {
            StreamRecord record = value.asRecord();
            if (record.hasTimestamp()) {
                target.write(0);
                target.writeLong(record.getTimestamp());
            } else {
                target.write(1);
            }
            this.typeSerializer.serialize(record.getValue(), target);
        } else if (value.isWatermark()) {
            target.write(2);
            target.writeLong(value.asWatermark().getTimestamp());
        } else {
            throw new RuntimeException();
        }
    }

    public StreamElement deserialize(DataInputView source) throws IOException {
        byte tag = source.readByte();
        if (tag == 0) {
            long timestamp = source.readLong();
            return new StreamRecord<Object>(this.typeSerializer.deserialize(source), timestamp);
        }
        if (tag == 1) {
            return new StreamRecord<Object>(this.typeSerializer.deserialize(source));
        }
        if (tag == 2) {
            return new Watermark(source.readLong());
        }
        throw new IOException("Corrupt stream, found tag: " + tag);
    }

    public StreamElement deserialize(StreamElement reuse, DataInputView source) throws IOException {
        byte tag = source.readByte();
        if (tag == 0) {
            long timestamp = source.readLong();
            Object value = this.typeSerializer.deserialize(source);
            StreamRecord reuseRecord = reuse.asRecord();
            reuseRecord.replace(value, timestamp);
            return reuseRecord;
        }
        if (tag == 1) {
            Object value = this.typeSerializer.deserialize(source);
            StreamRecord reuseRecord = reuse.asRecord();
            reuseRecord.replace(value);
            return reuseRecord;
        }
        if (tag == 2) {
            return new Watermark(source.readLong());
        }
        throw new IOException("Corrupt stream, found tag: " + tag);
    }

    public MultiplexingStreamRecordSerializerConfigSnapshot snapshotConfiguration() {
        return new MultiplexingStreamRecordSerializerConfigSnapshot<T>(this.typeSerializer);
    }

    public CompatibilityResult<StreamElement> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof MultiplexingStreamRecordSerializerConfigSnapshot) {
            Tuple2 previousTypeSerializerAndConfig = ((MultiplexingStreamRecordSerializerConfigSnapshot)configSnapshot).getSingleNestedSerializerAndConfig();
            CompatibilityResult compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)previousTypeSerializerAndConfig.f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)previousTypeSerializerAndConfig.f1), this.typeSerializer);
            if (!compatResult.isRequiresMigration()) {
                return CompatibilityResult.compatible();
            }
            if (compatResult.getConvertDeserializer() != null) {
                return CompatibilityResult.requiresMigration(new MultiplexingStreamRecordSerializer<T>(new TypeDeserializerAdapter(compatResult.getConvertDeserializer())));
            }
        }
        return CompatibilityResult.requiresMigration();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiplexingStreamRecordSerializer) {
            MultiplexingStreamRecordSerializer other = (MultiplexingStreamRecordSerializer)((Object)obj);
            return other.canEqual((Object)this) && this.typeSerializer.equals(other.typeSerializer);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof MultiplexingStreamRecordSerializer;
    }

    public int hashCode() {
        return this.typeSerializer.hashCode();
    }

    public static final class MultiplexingStreamRecordSerializerConfigSnapshot<T>
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;

        public MultiplexingStreamRecordSerializerConfigSnapshot() {
        }

        public MultiplexingStreamRecordSerializerConfigSnapshot(TypeSerializer<T> typeSerializer) {
            super(new TypeSerializer[]{typeSerializer});
        }

        public int getVersion() {
            return 1;
        }
    }
}

