/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.util.typedef.internal.S;

/**
 * Arguments for {@link VisorIdleVerifyDumpTask}.
 */
public class VisorIdleVerifyDumpTaskArg extends VisorIdleVerifyTaskArg {
    /** */
    private static final long serialVersionUID = 0L;
    /** */
    private boolean skipZeros;

    /**
     * Default constructor.
     */
    public VisorIdleVerifyDumpTaskArg() {
    }

    /**
     * @param caches Caches.
     * @param skipZeros Skip zeros partitions.
     */
    public VisorIdleVerifyDumpTaskArg(Set<String> caches, boolean skipZeros) {
        super(caches);
        this.skipZeros = skipZeros;
    }

    /**
     * @return Skip zeros partitions.
     */
    public boolean isSkipZeros() {
        return skipZeros;
    }

    /** {@inheritDoc} */
    @Override protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        out.writeBoolean(skipZeros);
    }

    /** {@inheritDoc} */
    @Override protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        skipZeros = in.readBoolean();
    }

    /** {@inheritDoc} */
    @Override public String toString() {
        return S.toString(VisorIdleVerifyDumpTaskArg.class, this);
    }
}
