/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.DhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.DhtResultSetEnlistFuture;
import org.apache.ignite.internal.processors.query.h2.NearResultSetEnlistFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public interface ResultSetEnlistFuture
extends DhtLockFuture<Long> {
    public static UpdateSourceIterator<?> createIterator(ResultSet rs) {
        return new ResultSetUpdateSourceIteratorWrapper(rs);
    }

    public void init();

    public static ResultSetEnlistFuture future(UUID nearNodeId, GridCacheVersion nearLockVer, MvccSnapshot mvccSnapshot, long threadId, IgniteUuid nearFutId, int nearMiniId, @Nullable int[] parts, GridDhtTxLocalAdapter tx, long timeout, GridCacheContext<?, ?> cctx, ResultSet rs) {
        if (tx.near()) {
            return new NearResultSetEnlistFuture(nearNodeId, nearLockVer, mvccSnapshot, threadId, nearFutId, nearMiniId, parts, tx, timeout, cctx, rs);
        }
        return new DhtResultSetEnlistFuture(nearNodeId, nearLockVer, mvccSnapshot, threadId, nearFutId, nearMiniId, parts, tx, timeout, cctx, rs);
    }

    public static class ResultSetUpdateSourceIteratorWrapper
    implements UpdateSourceIterator<Object> {
        private static final long serialVersionUID = -8745196216234843471L;
        private final ResultSet rs;
        private Boolean hasNext;
        private int keyColIdx;

        public ResultSetUpdateSourceIteratorWrapper(ResultSet rs) {
            this.rs = rs;
            this.keyColIdx = -1;
        }

        public EnlistOperation operation() {
            return EnlistOperation.LOCK;
        }

        public boolean hasNextX() {
            try {
                if (this.hasNext == null) {
                    this.hasNext = this.rs.next();
                }
                return this.hasNext;
            }
            catch (SQLException e) {
                throw new IgniteSQLException(e);
            }
        }

        public Object nextX() {
            if (!this.hasNextX()) {
                throw new NoSuchElementException();
            }
            try {
                if (this.keyColIdx == -1) {
                    this.keyColIdx = this.rs.getMetaData().getColumnCount();
                }
                Object object = this.rs.getObject(this.keyColIdx);
                return object;
            }
            catch (SQLException e) {
                throw new IgniteSQLException(e);
            }
            finally {
                this.hasNext = null;
            }
        }
    }
}

