/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

public class H2TwoStepCachedQueryKey {
    private final String schemaName;
    private final String sql;
    private final boolean grpByCollocated;
    private final boolean distributedJoins;
    private final boolean enforceJoinOrder;
    private final boolean isLocal;

    H2TwoStepCachedQueryKey(String schemaName, String sql, boolean grpByCollocated, boolean distributedJoins, boolean enforceJoinOrder, boolean isLocal) {
        this.schemaName = schemaName;
        this.sql = sql;
        this.grpByCollocated = grpByCollocated;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.isLocal = isLocal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H2TwoStepCachedQueryKey that = (H2TwoStepCachedQueryKey)o;
        if (this.grpByCollocated != that.grpByCollocated) {
            return false;
        }
        if (this.distributedJoins != that.distributedJoins) {
            return false;
        }
        if (this.enforceJoinOrder != that.enforceJoinOrder) {
            return false;
        }
        if (this.schemaName != null ? !this.schemaName.equals(that.schemaName) : that.schemaName != null) {
            return false;
        }
        return this.isLocal == that.isLocal && this.sql.equals(that.sql);
    }

    public int hashCode() {
        int res = this.schemaName != null ? this.schemaName.hashCode() : 0;
        res = 31 * res + this.sql.hashCode();
        res = 31 * res + (this.grpByCollocated ? 1 : 0);
        res += this.distributedJoins ? 2 : 0;
        res += this.enforceJoinOrder ? 4 : 0;
        return res += this.isLocal ? 8 : 0;
    }
}

