/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.session;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.querybuilder.Batch;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.cassandra.common.CassandraHelper;
import org.apache.ignite.cache.store.cassandra.common.RandomSleeper;
import org.apache.ignite.cache.store.cassandra.persistence.KeyValuePersistenceSettings;
import org.apache.ignite.cache.store.cassandra.session.BatchExecutionAssistant;
import org.apache.ignite.cache.store.cassandra.session.BatchLoaderAssistant;
import org.apache.ignite.cache.store.cassandra.session.CassandraSession;
import org.apache.ignite.cache.store.cassandra.session.ExecutionAssistant;
import org.apache.ignite.cache.store.cassandra.session.WrappedPreparedStatement;
import org.apache.ignite.cache.store.cassandra.session.WrappedSession;
import org.apache.ignite.cache.store.cassandra.session.pool.SessionPool;
import org.apache.ignite.cache.store.cassandra.session.transaction.Mutation;

public class CassandraSessionImpl
implements CassandraSession {
    private static final int CQL_EXECUTION_ATTEMPTS_COUNT = 20;
    private static final int CQL_EXECUTION_ATTEMPT_MIN_TIMEOUT = 100;
    private static final int CQL_EXECUTION_ATTEMPT_MAX_TIMEOUT = 500;
    private static final int CQL_ATTEMPTS_TIMEOUT_INCREMENT = 100;
    private volatile Cluster.Builder builder;
    private volatile Long generation = 0L;
    private volatile WrappedSession wrapperSes;
    private volatile int refCnt;
    private static final Map<String, WrappedPreparedStatement> sesStatements = new HashMap<String, WrappedPreparedStatement>();
    private Integer fetchSize;
    private ConsistencyLevel readConsistency;
    private ConsistencyLevel writeConsistency;
    private long expirationTimeout;
    private IgniteLogger log;
    private final Map<String, AtomicInteger> tblAbsenceHandlersCnt = new ConcurrentHashMap<String, AtomicInteger>();
    private final ReentrantLock refreshLock = new ReentrantLock();

    public CassandraSessionImpl(Cluster.Builder builder, Integer n, ConsistencyLevel consistencyLevel, ConsistencyLevel consistencyLevel2, long l, IgniteLogger igniteLogger) {
        this.builder = builder;
        this.fetchSize = n;
        this.readConsistency = consistencyLevel;
        this.writeConsistency = consistencyLevel2;
        this.expirationTimeout = l;
        this.log = igniteLogger;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <V> V execute(ExecutionAssistant<V> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R, V> R execute(BatchExecutionAssistant<R, V> var1_1, Iterable<? extends V> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 15[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(BatchLoaderAssistant var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(List<Mutation> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.decrementSessionRefs() == 0 && this.wrapperSes != null) {
            SessionPool.put(this, this.wrapperSes.ses, this.expirationTimeout);
            this.wrapperSes = null;
        }
    }

    private synchronized void refresh() {
        SessionPool.get(this);
        if (this.wrapperSes != null) {
            CassandraHelper.closeSession(this.wrapperSes.ses);
        }
        this.wrapperSes = null;
        this.session();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized WrappedSession session() {
        if (this.wrapperSes != null) {
            return this.wrapperSes;
        }
        Session session = SessionPool.get(this);
        if (session != null) {
            this.wrapperSes = new WrappedSession(session, this.generation);
            return this.wrapperSes;
        }
        Object object = sesStatements;
        synchronized (object) {
            sesStatements.clear();
        }
        try {
            session = this.builder.build().connect();
            object = this.generation;
            Long l = this.generation = Long.valueOf(this.generation + 1L);
            this.wrapperSes = new WrappedSession(session, this.generation);
        }
        catch (Throwable throwable) {
            throw new IgniteException("Failed to establish session with Cassandra database", throwable);
        }
        return this.wrapperSes;
    }

    private synchronized void incrementSessionRefs() {
        ++this.refCnt;
    }

    private synchronized int decrementSessionRefs() {
        if (this.refCnt != 0) {
            --this.refCnt;
        }
        return this.refCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WrappedPreparedStatement prepareStatement(String var1_1, String var2_2, KeyValuePersistenceSettings var3_3, boolean var4_4) {
        var5_5 = 0;
        var6_6 = null;
        var7_7 = "Failed to prepare Cassandra CQL statement: " + var2_2;
        var8_8 = this.newSleeper();
        this.incrementSessionRefs();
        try {
            block19: {
                var9_9 = CassandraSessionImpl.sesStatements;
                synchronized (var9_9) {
                    block17: {
                        var10_10 = CassandraSessionImpl.sesStatements.get(var2_2);
                        if (var10_10 == null) break block19;
                        if (this.generation != var10_10.generation) break block17;
                        var11_12 = var10_10;
                        return var11_12;
                    }
                    CassandraSessionImpl.sesStatements.remove(var2_2);
                }
            }
            while (var5_5 < 20) {
                var9_9 = null;
                try {
                    var9_9 = this.session();
                    var10_10 = var9_9.prepare(var2_2);
                    var11_13 = CassandraSessionImpl.sesStatements;
                    synchronized (var11_13) {
                        CassandraSessionImpl.sesStatements.put(var2_2, var10_10);
                    }
                    var11_13 = var10_10;
                    return var11_13;
                }
                catch (Throwable var10_11) {
                    block18: {
                        if (!CassandraHelper.isTableAbsenceError(var10_11)) ** GOTO lbl50
                        if (var4_4) break block18;
                        var11_14 = null;
                        this.decrementSessionRefs();
                        return var11_14;
                    }
                    try {
                        block20: {
                            this.handleTableAbsenceError(var1_1, var3_3);
                            break block20;
lbl50:
                            // 1 sources

                            if (!CassandraHelper.isHostsAvailabilityError(var10_11)) throw new IgniteException(var7_7, var10_11);
                            this.handleHostsAvailabilityError(var9_9 == null ? 0L : var9_9.generation, var10_11, var5_5, var7_7);
                        }
                        var6_6 = var10_11;
                        if (!CassandraHelper.isTableAbsenceError(var6_6)) {
                            var8_8.sleep();
                        }
                        ++var5_5;
                    }
                    catch (Throwable var14_17) {
                        throw var14_17;
                        throw new IgniteException(var7_7, var6_6);
                    }
                }
            }
        }
        finally {
            this.decrementSessionRefs();
        }
    }

    private void createKeyspace(KeyValuePersistenceSettings keyValuePersistenceSettings) {
        Throwable throwable = null;
        String string = "Failed to create Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "'";
        for (int i = 0; i < 20; ++i) {
            WrappedSession wrappedSession = null;
            try {
                wrappedSession = this.session();
                this.log.info("-----------------------------------------------------------------------");
                this.log.info("Creating Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "'");
                this.log.info("-----------------------------------------------------------------------\n\n" + keyValuePersistenceSettings.getKeyspaceDDLStatement() + "\n");
                this.log.info("-----------------------------------------------------------------------");
                wrappedSession.execute(keyValuePersistenceSettings.getKeyspaceDDLStatement());
                this.log.info("Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "' was successfully created");
                return;
            }
            catch (AlreadyExistsException alreadyExistsException) {
                this.log.info("Cassandra keyspace '" + keyValuePersistenceSettings.getKeyspace() + "' already exist");
                return;
            }
            catch (Throwable throwable2) {
                if (!CassandraHelper.isHostsAvailabilityError(throwable2)) {
                    throw new IgniteException(string, throwable2);
                }
                this.handleHostsAvailabilityError(wrappedSession == null ? 0L : wrappedSession.generation, throwable2, i, string);
                throwable = throwable2;
                continue;
            }
        }
        throw new IgniteException(string, throwable);
    }

    private void createTable(String string, KeyValuePersistenceSettings keyValuePersistenceSettings) {
        Throwable throwable = null;
        String string2 = keyValuePersistenceSettings.getKeyspace() + "." + string;
        String string3 = "Failed to create Cassandra table '" + string2 + "'";
        for (int i = 0; i < 20; ++i) {
            WrappedSession wrappedSession = null;
            try {
                wrappedSession = this.session();
                this.log.info("-----------------------------------------------------------------------");
                this.log.info("Creating Cassandra table '" + string2 + "'");
                this.log.info("-----------------------------------------------------------------------\n\n" + keyValuePersistenceSettings.getTableDDLStatement(string) + "\n");
                this.log.info("-----------------------------------------------------------------------");
                wrappedSession.execute(keyValuePersistenceSettings.getTableDDLStatement(string));
                this.log.info("Cassandra table '" + string2 + "' was successfully created");
                return;
            }
            catch (AlreadyExistsException alreadyExistsException) {
                this.log.info("Cassandra table '" + string2 + "' already exist");
                return;
            }
            catch (Throwable throwable2) {
                if (!CassandraHelper.isHostsAvailabilityError(throwable2) && !CassandraHelper.isKeyspaceAbsenceError(throwable2)) {
                    throw new IgniteException(string3, throwable2);
                }
                if (CassandraHelper.isKeyspaceAbsenceError(throwable2)) {
                    this.log.warning("Failed to create Cassandra table '" + string2 + "' cause appropriate keyspace doesn't exist", throwable2);
                    this.createKeyspace(keyValuePersistenceSettings);
                } else if (CassandraHelper.isHostsAvailabilityError(throwable2)) {
                    this.handleHostsAvailabilityError(wrappedSession == null ? 0L : wrappedSession.generation, throwable2, i, string3);
                }
                throwable = throwable2;
                continue;
            }
        }
        throw new IgniteException(string3, throwable);
    }

    private void createTableIndexes(String string, KeyValuePersistenceSettings keyValuePersistenceSettings) {
        List<String> list = keyValuePersistenceSettings.getIndexDDLStatements(string);
        if (list == null || list.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        String string2 = keyValuePersistenceSettings.getKeyspace() + "." + string;
        String string3 = "Failed to create indexes for Cassandra table " + string2;
        for (int i = 0; i < 20; ++i) {
            WrappedSession wrappedSession = null;
            try {
                wrappedSession = this.session();
                this.log.info("-----------------------------------------------------------------------");
                this.log.info("Creating indexes for Cassandra table '" + string2 + "'");
                this.log.info("-----------------------------------------------------------------------");
                for (String string4 : list) {
                    try {
                        this.log.info(string4);
                        this.log.info("-----------------------------------------------------------------------");
                        wrappedSession.execute(string4);
                    }
                    catch (AlreadyExistsException alreadyExistsException) {
                    }
                    catch (Throwable throwable2) {
                        if (throwable2 instanceof InvalidQueryException && "Index already exists".equals(throwable2.getMessage())) continue;
                        throw new IgniteException(string3, throwable2);
                    }
                }
                this.log.info("Indexes for Cassandra table '" + string2 + "' were successfully created");
                return;
            }
            catch (Throwable throwable3) {
                if (CassandraHelper.isHostsAvailabilityError(throwable3)) {
                    this.handleHostsAvailabilityError(wrappedSession == null ? 0L : wrappedSession.generation, throwable3, i, string3);
                } else if (CassandraHelper.isTableAbsenceError(throwable3)) {
                    this.createTable(string, keyValuePersistenceSettings);
                } else {
                    throw new IgniteException(string3, throwable3);
                }
                throwable = throwable3;
                continue;
            }
        }
        throw new IgniteException(string3, throwable);
    }

    private Statement tuneStatementExecutionOptions(Statement statement) {
        boolean bl;
        String string = "";
        if (statement instanceof BoundStatement) {
            string = ((BoundStatement)statement).preparedStatement().getQueryString().trim().toLowerCase();
        } else if (statement instanceof PreparedStatement) {
            string = ((PreparedStatement)statement).getQueryString().trim().toLowerCase();
        }
        boolean bl2 = string.startsWith("select");
        boolean bl3 = bl = statement instanceof Batch || statement instanceof BatchStatement || string.startsWith("insert") || string.startsWith("delete") || string.startsWith("update");
        if (bl2 && this.readConsistency != null) {
            statement.setConsistencyLevel(this.readConsistency);
        }
        if (bl && this.writeConsistency != null) {
            statement.setConsistencyLevel(this.writeConsistency);
        }
        if (this.fetchSize != null) {
            statement.setFetchSize(this.fetchSize.intValue());
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTableAbsenceError(String string2, KeyValuePersistenceSettings keyValuePersistenceSettings) {
        String string3 = keyValuePersistenceSettings.getKeyspace() + "." + string2;
        AtomicInteger atomicInteger = this.tblAbsenceHandlersCnt.computeIfAbsent(string3, string -> new AtomicInteger(-1));
        int n = atomicInteger.incrementAndGet();
        try {
            AtomicInteger atomicInteger2 = atomicInteger;
            synchronized (atomicInteger2) {
                block9: {
                    if (n == 0) break block9;
                    this.log.warning("Table " + string3 + " absence problem detected. Another thread already fixed it.");
                    return;
                }
                this.log.warning("Table " + string3 + " absence problem detected. Trying to create table.");
                this.createKeyspace(keyValuePersistenceSettings);
                this.createTable(string2, keyValuePersistenceSettings);
                this.createTableIndexes(string2, keyValuePersistenceSettings);
            }
        }
        finally {
            if (n == 0) {
                atomicInteger.set(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePreparedStatementClusterError(long l, Throwable throwable) {
        if (l < this.generation) {
            this.log.warning("Prepared statement cluster error detected, another thread already fixed the problem", throwable);
            return;
        }
        this.refreshLock.lock();
        try {
            if (l < this.generation) {
                this.log.warning("Prepared statement cluster error detected, another thread already fixed the problem", throwable);
                return;
            }
            this.log.warning("Prepared statement cluster error detected, refreshing Cassandra session", throwable);
            this.refresh();
            this.log.warning("Cassandra session refreshed");
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleHostsAvailabilityError(long l, Throwable throwable, int n, String string) {
        block8: {
            if (n >= 20) {
                this.log.error("Host availability problem detected. Number of CQL execution attempts reached maximum 20, exception will be thrown to upper execution layer.", throwable);
                throw string == null ? new IgniteException(throwable) : new IgniteException(string, throwable);
            }
            if (n == 5 || n == 10 || n == 15 || n == 19) {
                this.refreshLock.lock();
                try {
                    if (l < this.generation) {
                        this.log.warning("Host availability problem detected, but already handled by another thread");
                        break block8;
                    }
                    this.log.warning("Host availability problem detected, CQL execution attempt  " + (n + 1) + ", refreshing Cassandra session", throwable);
                    this.refresh();
                    this.log.warning("Cassandra session refreshed");
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.refreshLock.unlock();
                }
            }
        }
        this.log.warning("Host availability problem detected, CQL execution attempt " + (n + 1) + ", sleeping extra " + 500 + " milliseconds", throwable);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log.warning("Sleep completed");
        return false;
    }

    private RandomSleeper newSleeper() {
        return new RandomSleeper(100, 500, 100, this.log);
    }
}

