/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.jdk.GridClientJdkMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientZipOptimizedMarshaller;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.protocols.GridRestProtocolAdapter;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestNioListener;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestParser;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.jetbrains.annotations.Nullable;

public class GridTcpRestProtocol
extends GridRestProtocolAdapter {
    private GridNioServer<GridClientMessage> srv;
    private GridTcpRestNioListener lsnr;

    public GridTcpRestProtocol(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public String name() {
        return "TCP binary";
    }

    @Override
    public void start(GridRestProtocolHandler hnd) throws IgniteCheckedException {
        assert (hnd != null);
        ConnectorConfiguration cfg = this.ctx.config().getConnectorConfiguration();
        assert (cfg != null);
        this.lsnr = new GridTcpRestNioListener(this.log, this, hnd, this.ctx);
        GridTcpRestParser parser = new GridTcpRestParser(false, this.ctx.marshallerContext().jdkMarshaller());
        try {
            this.host = this.resolveRestTcpHost(this.ctx.config());
            SSLContext sslCtx = null;
            if (cfg.isSslEnabled()) {
                Factory<SSLContext> igniteFactory = this.ctx.config().getSslContextFactory();
                Factory<SSLContext> factory = cfg.getSslFactory();
                GridSslContextFactory depFactory = cfg.getSslContextFactory();
                if (factory == null && depFactory == null && igniteFactory == null) {
                    throw new SSLException("SSL is enabled, but SSL context factory is not specified.");
                }
                sslCtx = factory != null ? (SSLContext)factory.create() : (depFactory != null ? depFactory.createSslContext() : (SSLContext)igniteFactory.create());
            }
            int startPort = cfg.getPort();
            int portRange = cfg.getPortRange();
            int lastPort = portRange == 0 ? startPort : startPort + portRange - 1;
            for (int port0 = startPort; port0 <= lastPort; ++port0) {
                if (!this.startTcpServer(this.host, port0, this.lsnr, parser, sslCtx, cfg)) continue;
                this.port = port0;
                if (this.log.isInfoEnabled()) {
                    this.log.info(this.startInfo());
                }
                return;
            }
            U.warn(this.log, "Failed to start TCP binary REST server (possibly all ports in range are in use) [firstPort=" + cfg.getPort() + ", lastPort=" + lastPort + ", host=" + this.host + ']');
        }
        catch (SSLException e) {
            U.warn(this.log, "Failed to start " + this.name() + " protocol on port " + this.port + ". Check if SSL context factory is properly configured: " + e.getMessage());
        }
        catch (IOException e) {
            U.warn(this.log, "Failed to start " + this.name() + " protocol on port " + this.port + ". Check restTcpHost configuration property: " + e.getMessage());
        }
    }

    @Override
    public void onKernalStart() {
        super.onKernalStart();
        HashMap<Byte, GridClientMarshaller> marshMap = new HashMap<Byte, GridClientMarshaller>();
        ArrayList<PluginProvider> providers = new ArrayList<PluginProvider>(this.ctx.plugins().allProviders());
        GridClientOptimizedMarshaller optMarsh = new GridClientOptimizedMarshaller(providers);
        marshMap.put((byte)1, optMarsh);
        marshMap.put((byte)3, new GridClientZipOptimizedMarshaller(optMarsh, providers));
        try {
            IgnitePredicate<String> clsFilter = MarshallerUtils.classNameFilter(this.getClass().getClassLoader());
            marshMap.put((byte)2, new GridClientJdkMarshaller(clsFilter));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        this.lsnr.marshallers(marshMap);
    }

    @Override
    public void stop() {
        if (this.srv != null) {
            this.ctx.ports().deregisterPorts(this.getClass());
            this.srv.stop();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(this.stopInfo());
        }
    }

    private InetAddress resolveRestTcpHost(IgniteConfiguration cfg) throws IOException {
        String host = cfg.getConnectorConfiguration().getHost();
        if (host == null) {
            host = cfg.getLocalHost();
        }
        return U.resolveLocalHost(host);
    }

    private boolean startTcpServer(InetAddress hostAddr, int port, GridNioServerListener<GridClientMessage> lsnr, GridNioParser parser, @Nullable SSLContext sslCtx, ConnectorConfiguration cfg) {
        try {
            GridNioFilter[] filters;
            GridNioCodecFilter codec = new GridNioCodecFilter(parser, this.log, false);
            if (sslCtx != null) {
                GridNioSslFilter sslFilter = new GridNioSslFilter(sslCtx, cfg.isDirectBuffer(), ByteOrder.nativeOrder(), this.log);
                sslFilter.directMode(false);
                boolean auth = cfg.isSslClientAuth();
                sslFilter.wantClientAuth(auth);
                sslFilter.needClientAuth(auth);
                filters = new GridNioFilter[]{codec, sslFilter};
            } else {
                filters = new GridNioFilter[]{codec};
            }
            this.srv = GridNioServer.builder().address(hostAddr).port(port).listener(lsnr).logger(this.log).selectorCount(cfg.getSelectorCount()).igniteInstanceName(this.ctx.igniteInstanceName()).serverName("tcp-rest").tcpNoDelay(cfg.isNoDelay()).directBuffer(cfg.isDirectBuffer()).byteOrder(ByteOrder.nativeOrder()).socketSendBufferSize(cfg.getSendBufferSize()).socketReceiveBufferSize(cfg.getReceiveBufferSize()).sendQueueLimit(cfg.getSendQueueLimit()).filters(filters).directMode(false).build();
            this.srv.idleTimeout(cfg.getIdleTimeout());
            this.srv.start();
            this.ctx.ports().registerPort(port, IgnitePortProtocol.TCP, this.getClass());
            return true;
        }
        catch (IgniteCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to start " + this.name() + " protocol on port " + port + ": " + e.getMessage());
            }
            return false;
        }
    }

    @Override
    protected String getAddressPropertyName() {
        return "org.apache.ignite.rest.tcp.addrs";
    }

    @Override
    protected String getHostNamePropertyName() {
        return "org.apache.ignite.rest.tcp.host.names";
    }

    @Override
    protected String getPortPropertyName() {
        return "org.apache.ignite.rest.tcp.port";
    }
}

