/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VerifyBackupPartitionsTaskV2
extends ComputeTaskAdapter<VisorIdleVerifyTaskArg, IdleVerifyResultV2> {
    public static final IgniteProductVersion V2_SINCE_VER = IgniteProductVersion.fromString("2.5.3");
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, VisorIdleVerifyTaskArg arg) throws IgniteException {
        HashMap<VerifyBackupPartitionsJobV2, ClusterNode> jobs = new HashMap<VerifyBackupPartitionsJobV2, ClusterNode>();
        for (ClusterNode node : subgrid) {
            jobs.put(new VerifyBackupPartitionsJobV2(arg), node);
        }
        return jobs;
    }

    @Override
    @Nullable
    public IdleVerifyResultV2 reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap<PartitionKeyV2, List> clusterHashes = new HashMap<PartitionKeyV2, List>();
        for (ComputeJobResult res : results) {
            Map nodeHashes = (Map)res.getData();
            for (Map.Entry e : nodeHashes.entrySet()) {
                List records = clusterHashes.computeIfAbsent((PartitionKeyV2)e.getKey(), k -> new ArrayList());
                records.add(e.getValue());
            }
        }
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> updateCntrConflicts = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> movingParts = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        for (Map.Entry e : clusterHashes.entrySet()) {
            Integer partHash = null;
            Long updateCntr = null;
            for (PartitionHashRecordV2 record : (List)e.getValue()) {
                if (record.size() == Long.MIN_VALUE) {
                    List records = movingParts.computeIfAbsent((PartitionKeyV2)e.getKey(), (Function<PartitionKeyV2, List<PartitionHashRecordV2>>)((Function<PartitionKeyV2, List>)k -> new ArrayList()));
                    records.add(record);
                    continue;
                }
                if (partHash == null) {
                    partHash = record.partitionHash();
                    updateCntr = record.updateCounter();
                    continue;
                }
                if (record.updateCounter() != updateCntr.longValue()) {
                    updateCntrConflicts.putIfAbsent((PartitionKeyV2)e.getKey(), (List<PartitionHashRecordV2>)e.getValue());
                }
                if (record.partitionHash() == partHash.intValue()) continue;
                hashConflicts.putIfAbsent((PartitionKeyV2)e.getKey(), (List<PartitionHashRecordV2>)e.getValue());
            }
        }
        return new IdleVerifyResultV2(updateCntrConflicts, hashConflicts, movingParts);
    }

    private static class VerifyBackupPartitionsJobV2
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private VisorIdleVerifyTaskArg arg;
        private final AtomicInteger completionCntr = new AtomicInteger(0);

        public VerifyBackupPartitionsJobV2(VisorIdleVerifyTaskArg arg) {
            this.arg = arg;
        }

        @Override
        public Map<PartitionKeyV2, PartitionHashRecordV2> execute() throws IgniteException {
            HashSet<Integer> grpIds = new HashSet<Integer>();
            HashSet<String> missingCaches = new HashSet<String>();
            if (this.arg.getCaches() != null) {
                for (String string : this.arg.getCaches()) {
                    DynamicCacheDescriptor dynamicCacheDescriptor = this.ignite.context().cache().cacheDescriptor(string);
                    if (dynamicCacheDescriptor == null) {
                        missingCaches.add(string);
                        continue;
                    }
                    grpIds.add(dynamicCacheDescriptor.groupId());
                }
                if (!missingCaches.isEmpty()) {
                    StringBuilder strBuilder = new StringBuilder("The following caches do not exist: ");
                    for (String string : missingCaches) {
                        strBuilder.append(string).append(", ");
                    }
                    strBuilder.delete(strBuilder.length() - 2, strBuilder.length());
                    throw new IgniteException(strBuilder.toString());
                }
            } else {
                Collection<CacheGroupContext> groups = this.ignite.context().cache().cacheGroups();
                for (CacheGroupContext cacheGroupContext : groups) {
                    if (cacheGroupContext.systemCache() || cacheGroupContext.isLocal()) continue;
                    grpIds.add(cacheGroupContext.groupId());
                }
            }
            ArrayList<Future<Map<PartitionKeyV2, PartitionHashRecordV2>>> partHashCalcFutures = new ArrayList<Future<Map<PartitionKeyV2, PartitionHashRecordV2>>>();
            this.completionCntr.set(0);
            for (Integer n : grpIds) {
                CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(n);
                if (grpCtx == null) continue;
                List<GridDhtLocalPartition> parts = grpCtx.topology().localPartitions();
                for (GridDhtLocalPartition part : parts) {
                    partHashCalcFutures.add(this.calculatePartitionHashAsync(grpCtx, part));
                }
            }
            HashMap<PartitionKeyV2, PartitionHashRecordV2> hashMap = new HashMap<PartitionKeyV2, PartitionHashRecordV2>();
            long l = U.currentTimeMillis();
            int i = 0;
            while (i < partHashCalcFutures.size()) {
                Future fut = (Future)partHashCalcFutures.get(i);
                try {
                    Map partHash = (Map)fut.get(100L, TimeUnit.MILLISECONDS);
                    hashMap.putAll(partHash);
                    ++i;
                }
                catch (InterruptedException | ExecutionException e) {
                    for (int j = i + 1; j < partHashCalcFutures.size(); ++j) {
                        ((Future)partHashCalcFutures.get(j)).cancel(false);
                    }
                    if (e instanceof InterruptedException) {
                        throw new IgniteInterruptedException((InterruptedException)e);
                    }
                    if (e.getCause() instanceof IgniteException) {
                        throw (IgniteException)e.getCause();
                    }
                    throw new IgniteException(e.getCause());
                }
                catch (TimeoutException ignored) {
                    if (U.currentTimeMillis() - l <= 180000L) continue;
                    l = U.currentTimeMillis();
                    this.log.warning("idle_verify is still running, processed " + this.completionCntr.get() + " of " + partHashCalcFutures.size() + " local partitions");
                }
            }
            return hashMap;
        }

        private Future<Map<PartitionKeyV2, PartitionHashRecordV2>> calculatePartitionHashAsync(final CacheGroupContext grpCtx, final GridDhtLocalPartition part) {
            return ForkJoinPool.commonPool().submit(new Callable<Map<PartitionKeyV2, PartitionHashRecordV2>>(){

                @Override
                public Map<PartitionKeyV2, PartitionHashRecordV2> call() throws Exception {
                    return this.calculatePartitionHash(grpCtx, part);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<PartitionKeyV2, PartitionHashRecordV2> calculatePartitionHash(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
            long partSize;
            if (!part.reserve()) {
                return Collections.emptyMap();
            }
            int partHash = 0;
            long updateCntrBefore = part.updateCounter();
            PartitionKeyV2 partKey = new PartitionKeyV2(grpCtx.groupId(), part.id(), grpCtx.cacheOrGroupName());
            Object consId = this.ignite.context().discovery().localNode().consistentId();
            boolean isPrimary = part.primary(grpCtx.topology().readyTopologyVersion());
            try {
                if (part.state() == GridDhtPartitionState.MOVING) {
                    PartitionHashRecordV2 movingHashRecord = new PartitionHashRecordV2(partKey, isPrimary, consId, partHash, updateCntrBefore, Long.MIN_VALUE);
                    Map<PartitionKeyV2, PartitionHashRecordV2> map = Collections.singletonMap(partKey, movingHashRecord);
                    return map;
                }
                if (part.state() != GridDhtPartitionState.OWNING) {
                    Map<PartitionKeyV2, PartitionHashRecordV2> movingHashRecord = Collections.emptyMap();
                    return movingHashRecord;
                }
                partSize = part.dataStore().fullSize();
                GridIterator<CacheDataRow> it = grpCtx.offheap().partitionIterator(part.id());
                while (it.hasNextX()) {
                    CacheDataRow row = it.nextX();
                    partHash += row.key().hashCode();
                    partHash += Arrays.hashCode(row.value().valueBytes(grpCtx.cacheObjectContext()));
                }
                long updateCntrAfter = part.updateCounter();
                if (updateCntrBefore != updateCntrAfter) {
                    throw new IgniteException("Cluster is not idle: update counter of partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "] changed during hash calculation [before=" + updateCntrBefore + ", after=" + updateCntrAfter + "]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Can't calculate partition hash [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]", e);
                Map<PartitionKeyV2, PartitionHashRecordV2> map = Collections.emptyMap();
                return map;
            }
            finally {
                part.release();
            }
            PartitionHashRecordV2 partRec = new PartitionHashRecordV2(partKey, isPrimary, consId, partHash, updateCntrBefore, partSize);
            this.completionCntr.incrementAndGet();
            return Collections.singletonMap(partKey, partRec);
        }
    }
}

