/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;

public class CacheDataRowStore
extends RowStore {
    private final int partId;
    private final CacheGroupContext grp;

    public CacheDataRowStore(CacheGroupContext grp, FreeList freeList, int partId) {
        super(grp, freeList);
        this.partId = partId;
        this.grp = grp;
    }

    CacheSearchRow keySearchRow(int cacheId, int hash, long link) {
        return this.initDataRow(new DataRow(this.grp, hash, link, this.partId, CacheDataRowAdapter.RowData.KEY_ONLY), cacheId);
    }

    MvccDataRow mvccRow(int cacheId, int hash, long link, CacheDataRowAdapter.RowData rowData, long crdVer, long mvccCntr, int opCntr) {
        MvccDataRow dataRow = new MvccDataRow(this.grp, hash, link, this.partId, rowData, crdVer, mvccCntr, opCntr);
        return this.initDataRow(dataRow, cacheId);
    }

    CacheDataRow dataRow(int cacheId, int hash, long link, CacheDataRowAdapter.RowData rowData) {
        return this.initDataRow(new DataRow(this.grp, hash, link, this.partId, rowData), cacheId);
    }

    private <T extends DataRow> T initDataRow(T dataRow, int cacheId) {
        if (dataRow.cacheId() == 0 && this.grp.sharedGroup()) {
            dataRow.cacheId(cacheId);
        }
        return dataRow;
    }
}

