/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.reuse;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;

public class ReuseListImpl
extends PagesList
implements ReuseList {
    private static final AtomicReferenceFieldUpdater<ReuseListImpl, PagesList.Stripe[]> bucketUpdater = AtomicReferenceFieldUpdater.newUpdater(ReuseListImpl.class, PagesList.Stripe[].class, "bucket");
    private volatile PagesList.Stripe[] bucket;

    public ReuseListImpl(int cacheId, String name, PageMemory pageMem, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew) throws IgniteCheckedException {
        super(cacheId, name, pageMem, 1, wal, metaPageId);
        this.reuseList = this;
        this.init(metaPageId, initNew);
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        assert (bucket == 0) : bucket;
        return true;
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteCheckedException {
        this.put(bag, 0L, 0L, 0L, 0);
    }

    @Override
    public long takeRecycledPage() throws IgniteCheckedException {
        return this.takeEmptyPage(0, null);
    }

    @Override
    public long recycledPagesCount() throws IgniteCheckedException {
        return this.storedPagesCount(0);
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.bucket;
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        return bucketUpdater.compareAndSet(this, exp, upd);
    }

    public String toString() {
        return "ReuseList [name=" + this.name + ']';
    }
}

