/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.filename;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFoldersResolver;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PdsConsistentIdProcessor
extends GridProcessorAdapter
implements PdsFoldersResolver {
    private static final String DB_FOLDER_PREFIX = "node";
    private static final String NODEIDX_UID_SEPARATOR = "-";
    private static final String NODE_PATTERN = "node[0-9]*-";
    private static final String UUID_STR_PATTERN = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final String SUBDIR_PATTERN = "node[0-9]*-[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    public static final FileFilter DB_SUBFOLDERS_NEW_STYLE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && pathname.getName().matches(PdsConsistentIdProcessor.SUBDIR_PATTERN);
        }
    };
    private static final FileFilter DB_SUBFOLDERS_OLD_STYLE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && !"wal".equals(pathname.getName()) && !pathname.getName().matches(PdsConsistentIdProcessor.SUBDIR_PATTERN);
        }
    };
    public static final String DB_DEFAULT_FOLDER = "db";
    private IgniteConfiguration cfg;
    private IgniteLogger log;
    private GridKernalContext ctx;
    private PdsFolderSettings settings;

    public PdsConsistentIdProcessor(GridKernalContext ctx) {
        super(ctx);
        this.cfg = ctx.config();
        this.log = ctx.log(PdsFoldersResolver.class);
        this.ctx = ctx;
    }

    private PdsFolderSettings compatibleResolve(@Nullable File pstStoreBasePath, @NotNull Serializable consistentId) {
        if (this.cfg.getConsistentId() != null) {
            return new PdsFolderSettings(pstStoreBasePath, this.cfg.getConsistentId());
        }
        return new PdsFolderSettings(pstStoreBasePath, consistentId);
    }

    @Override
    public PdsFolderSettings resolveFolders() throws IgniteCheckedException {
        if (this.settings == null) {
            this.settings = this.prepareNewSettings();
            if (!this.settings.isCompatible()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Consistent ID used for local node is [" + this.settings.consistentId() + "] according to persistence data storage folders");
                }
                this.ctx.discovery().consistentId(this.settings.consistentId());
            }
        }
        return this.settings;
    }

    private PdsFolderSettings prepareNewSettings() throws IgniteCheckedException {
        File pstStoreBasePath = this.resolvePersistentStoreBasePath();
        Serializable consistentId = this.ctx.discovery().consistentId();
        if (!CU.isPersistenceEnabled(this.cfg)) {
            return this.compatibleResolve(pstStoreBasePath, consistentId);
        }
        if (this.ctx.clientNode()) {
            return new PdsFolderSettings(pstStoreBasePath, UUID.randomUUID());
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_DATA_STORAGE_FOLDER_BY_CONSISTENT_ID", false)) {
            return this.compatibleResolve(pstStoreBasePath, consistentId);
        }
        if (this.cfg.getConsistentId() != null) {
            return new PdsFolderSettings(pstStoreBasePath, this.cfg.getConsistentId());
        }
        String subFolder = U.maskForFileName(consistentId.toString());
        GridCacheDatabaseSharedManager.FileLockHolder oldStyleFolderLockHolder = this.tryLock(new File(pstStoreBasePath, subFolder));
        if (oldStyleFolderLockHolder != null) {
            return new PdsFolderSettings(pstStoreBasePath, subFolder, consistentId, oldStyleFolderLockHolder, true);
        }
        File[] oldStyleFolders = pstStoreBasePath.listFiles(DB_SUBFOLDERS_OLD_STYLE_FILTER);
        if (oldStyleFolders != null && oldStyleFolders.length != 0) {
            for (File folder : oldStyleFolders) {
                String path = this.getPathDisplayableInfo(folder);
                U.warn(this.log, "There is other non-empty storage folder under storage base directory [" + path + "]");
            }
        }
        for (FolderCandidate next : this.getNodeIndexSortedCandidates(pstStoreBasePath)) {
            GridCacheDatabaseSharedManager.FileLockHolder fileLockHolder = this.tryLock(next.subFolderFile());
            if (fileLockHolder == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Successfully locked persistence storage folder [" + next.subFolderFile() + "]");
            }
            return new PdsFolderSettings(pstStoreBasePath, next.subFolderFile().getName(), next.uuid(), fileLockHolder, false);
        }
        try (GridCacheDatabaseSharedManager.FileLockHolder rootDirLock = this.lockRootDirectory(pstStoreBasePath);){
            List<FolderCandidate> sortedCandidates = this.getNodeIndexSortedCandidates(pstStoreBasePath);
            int nodeIdx = sortedCandidates.isEmpty() ? 0 : sortedCandidates.get(sortedCandidates.size() - 1).nodeIndex() + 1;
            PdsFolderSettings pdsFolderSettings = this.generateAndLockNewDbStorage(pstStoreBasePath, nodeIdx);
            return pdsFolderSettings;
        }
    }

    private static FolderParams folderSize(File dir) {
        FolderParams params = new FolderParams();
        PdsConsistentIdProcessor.visitFolder(dir, params);
        return params;
    }

    private static void visitFolder(File dir, FolderParams params) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                PdsConsistentIdProcessor.visitFolder(file, params);
                continue;
            }
            params.size = params.size + file.length();
            params.lastModified = Math.max(params.lastModified, dir.lastModified());
        }
    }

    @NotNull
    private String getPathDisplayableInfo(File folder) {
        SB res = new SB();
        res.a(this.getCanonicalPath(folder));
        res.a(", ");
        FolderParams params = PdsConsistentIdProcessor.folderSize(folder);
        res.a(params.size);
        res.a(" bytes, modified ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
        res.a(simpleDateFormat.format(params.lastModified));
        res.a(" ");
        return res.toString();
    }

    @NotNull
    private String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ignored) {
            return file.getAbsolutePath();
        }
    }

    private static String padStart(String str, int minLength, char padChar) {
        A.notNull(str, "String should not be empty");
        if (str.length() >= minLength) {
            return str;
        }
        SB sb = new SB(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.a(padChar);
        }
        sb.a(str);
        return sb.toString();
    }

    @NotNull
    private PdsFolderSettings generateAndLockNewDbStorage(File pstStoreBasePath, int nodeIdx) throws IgniteCheckedException {
        UUID uuid = UUID.randomUUID();
        String consIdBasedFolder = PdsConsistentIdProcessor.genNewStyleSubfolderName(nodeIdx, uuid);
        File newRandomFolder = U.resolveWorkDirectory(pstStoreBasePath.getAbsolutePath(), consIdBasedFolder, false);
        GridCacheDatabaseSharedManager.FileLockHolder fileLockHolder = this.tryLock(newRandomFolder);
        if (fileLockHolder != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Successfully created new persistent storage folder [" + newRandomFolder + "]");
            }
            return new PdsFolderSettings(pstStoreBasePath, consIdBasedFolder, uuid, fileLockHolder, false);
        }
        throw new IgniteCheckedException("Unable to lock file generated randomly [" + newRandomFolder + "]");
    }

    @NotNull
    public static String genNewStyleSubfolderName(int nodeIdx, UUID uuid) {
        String uuidAsStr = uuid.toString();
        assert (uuidAsStr.matches(UUID_STR_PATTERN));
        String nodeIdxPadded = PdsConsistentIdProcessor.padStart(Integer.toString(nodeIdx), 2, '0');
        return DB_FOLDER_PREFIX + nodeIdxPadded + NODEIDX_UID_SEPARATOR + uuidAsStr;
    }

    @NotNull
    private GridCacheDatabaseSharedManager.FileLockHolder lockRootDirectory(File pstStoreBasePath) throws IgniteCheckedException {
        GridCacheDatabaseSharedManager.FileLockHolder rootDirLock;
        int retry = 0;
        while ((rootDirLock = this.tryLock(pstStoreBasePath)) == null) {
            if (retry > 600) {
                throw new IgniteCheckedException("Unable to start under DB storage path [" + pstStoreBasePath + "]. Lock is being held to root directory");
            }
            ++retry;
        }
        return rootDirLock;
    }

    @Nullable
    private List<FolderCandidate> getNodeIndexSortedCandidates(File pstStoreBasePath) {
        File[] files = pstStoreBasePath.listFiles(DB_SUBFOLDERS_NEW_STYLE_FILTER);
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<FolderCandidate> res = new ArrayList<FolderCandidate>();
        for (File file : files) {
            FolderCandidate candidate = this.parseFileName(file);
            if (candidate == null) continue;
            res.add(candidate);
        }
        Collections.sort(res, new Comparator<FolderCandidate>(){

            @Override
            public int compare(FolderCandidate c1, FolderCandidate c2) {
                return Integer.compare(c1.nodeIndex(), c2.nodeIndex());
            }
        });
        return res;
    }

    private GridCacheDatabaseSharedManager.FileLockHolder tryLock(File dbStoreDirWithSubdirectory) {
        if (!dbStoreDirWithSubdirectory.exists()) {
            return null;
        }
        String path = dbStoreDirWithSubdirectory.getAbsolutePath();
        GridCacheDatabaseSharedManager.FileLockHolder fileLockHolder = new GridCacheDatabaseSharedManager.FileLockHolder(path, this.ctx, this.log);
        try {
            fileLockHolder.tryLock(1000L);
            return fileLockHolder;
        }
        catch (IgniteCheckedException e) {
            U.closeQuiet(fileLockHolder);
            if (this.log.isInfoEnabled()) {
                this.log.info("Unable to acquire lock to file [" + path + "], reason: " + e.getMessage());
            }
            return null;
        }
    }

    @Nullable
    private File resolvePersistentStoreBasePath() throws IgniteCheckedException {
        DataStorageConfiguration dsCfg = this.cfg.getDataStorageConfiguration();
        if (dsCfg == null) {
            return null;
        }
        String pstPath = dsCfg.getStoragePath();
        return U.resolveWorkDirectory(this.cfg.getWorkDirectory(), pstPath != null ? pstPath : DB_DEFAULT_FOLDER, false);
    }

    private FolderCandidate parseFileName(@NotNull File subFolderFile) {
        return PdsConsistentIdProcessor.parseSubFolderName(subFolderFile, this.log);
    }

    @Nullable
    public static FolderCandidate parseSubFolderName(@NotNull File subFolderFile, @NotNull IgniteLogger log) {
        String fileName = subFolderFile.getName();
        Matcher matcher = Pattern.compile(NODE_PATTERN).matcher(fileName);
        if (!matcher.find()) {
            return null;
        }
        int uidStart = matcher.end();
        try {
            String uid = fileName.substring(uidStart);
            UUID uuid = UUID.fromString(uid);
            String substring = fileName.substring(DB_FOLDER_PREFIX.length(), uidStart - NODEIDX_UID_SEPARATOR.length());
            int idx = Integer.parseInt(substring);
            return new FolderCandidate(subFolderFile, idx, uuid);
        }
        catch (Exception e) {
            U.warn(log, "Unable to parse new style file format from [" + subFolderFile.getAbsolutePath() + "]: " + e);
            return null;
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        GridCacheDatabaseSharedManager.FileLockHolder fileLockHolder;
        if (this.settings != null && (fileLockHolder = this.settings.getLockedFileLockHolder()) != null) {
            fileLockHolder.close();
        }
        super.stop(cancel);
    }

    public static class FolderCandidate {
        private final File subFolderFile;
        private final int nodeIdx;
        private final UUID uuid;

        public FolderCandidate(File subFolderFile, int nodeIdx, UUID uuid) {
            this.subFolderFile = subFolderFile;
            this.nodeIdx = nodeIdx;
            this.uuid = uuid;
        }

        public int nodeIndex() {
            return this.nodeIdx;
        }

        public Serializable uuid() {
            return this.uuid;
        }

        public File subFolderFile() {
            return this.subFolderFile;
        }
    }

    private static class FolderParams {
        private long size;
        private long lastModified;

        private FolderParams() {
        }
    }
}

