/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.ratemetrics.HitRateMetrics;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;

public class DataStorageMetricsImpl
implements DataStorageMetricsMXBean {
    private volatile HitRateMetrics walLoggingRate;
    private volatile HitRateMetrics walWritingRate;
    private volatile HitRateMetrics walFsyncTimeDuration;
    private volatile HitRateMetrics walFsyncTimeNum;
    private volatile HitRateMetrics walBuffPollSpinsNum;
    private volatile long lastCpLockWaitDuration;
    private volatile long lastCpMarkDuration;
    private volatile long lastCpPagesWriteDuration;
    private volatile long lastCpDuration;
    private volatile long lastCpFsyncDuration;
    private volatile long lastCpTotalPages;
    private volatile long lastCpDataPages;
    private volatile long lastCpCowPages;
    private volatile long rateTimeInterval;
    private volatile int subInts;
    private volatile boolean metricsEnabled;
    private volatile IgniteWriteAheadLogManager wal;
    private volatile IgniteOutClosure<Long> walSizeProvider;
    private volatile long lastWalSegmentRollOverTime;
    private final AtomicLong totalCheckpointTime = new AtomicLong();
    private volatile Collection<DataRegionMetrics> regionMetrics;

    public DataStorageMetricsImpl(boolean metricsEnabled, long rateTimeInterval, int subInts) {
        this.metricsEnabled = metricsEnabled;
        this.rateTimeInterval = rateTimeInterval;
        this.subInts = subInts;
        this.resetRates();
    }

    @Override
    public float getWalLoggingRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.walLoggingRate.getRate() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getWalWritingRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.walWritingRate.getRate() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public int getWalArchiveSegments() {
        if (!this.metricsEnabled) {
            return 0;
        }
        return this.wal.walArchiveSegments();
    }

    @Override
    public float getWalFsyncTimeAverage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long numRate = this.walFsyncTimeNum.getRate();
        if (numRate == 0L) {
            return 0.0f;
        }
        return (float)this.walFsyncTimeDuration.getRate() / (float)numRate;
    }

    @Override
    public long getWalBuffPollSpinsRate() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.walBuffPollSpinsNum.getRate();
    }

    @Override
    public long getLastCheckpointDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpDuration;
    }

    @Override
    public long getLastCheckpointLockWaitDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpLockWaitDuration;
    }

    @Override
    public long getLastCheckpointMarkDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpMarkDuration;
    }

    @Override
    public long getLastCheckpointPagesWriteDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpPagesWriteDuration;
    }

    @Override
    public long getLastCheckpointFsyncDuration() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpFsyncDuration;
    }

    @Override
    public long getLastCheckpointTotalPagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpTotalPages;
    }

    @Override
    public long getLastCheckpointDataPagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpDataPages;
    }

    @Override
    public long getLastCheckpointCopiedOnWritePagesNumber() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastCpCowPages;
    }

    @Override
    public void enableMetrics() {
        this.metricsEnabled = true;
    }

    @Override
    public void disableMetrics() {
        this.metricsEnabled = false;
    }

    @Override
    public void rateTimeInterval(long rateTimeInterval) {
        this.rateTimeInterval = rateTimeInterval;
        this.resetRates();
    }

    @Override
    public void subIntervals(int subInts) {
        this.subInts = subInts;
        this.resetRates();
    }

    @Override
    public long getWalTotalSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        IgniteOutClosure<Long> walSize = this.walSizeProvider;
        return walSize != null ? walSize.apply() : 0L;
    }

    @Override
    public long getWalLastRollOverTime() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.lastWalSegmentRollOverTime;
    }

    @Override
    public long getCheckpointTotalTime() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.totalCheckpointTime.get();
    }

    @Override
    public long getDirtyPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long dirtyPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            dirtyPages += rm.getDirtyPages();
        }
        return dirtyPages;
    }

    @Override
    public long getPagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long readPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            readPages += rm.getPagesRead();
        }
        return readPages;
    }

    @Override
    public long getPagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long writtenPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            writtenPages += rm.getPagesWritten();
        }
        return writtenPages;
    }

    @Override
    public long getPagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long replacedPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            replacedPages += rm.getPagesReplaced();
        }
        return replacedPages;
    }

    @Override
    public long getOffHeapSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapSize += rm.getOffHeapSize();
        }
        return offHeapSize;
    }

    @Override
    public long getOffheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapUsedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapUsedSize += rm.getOffheapUsedSize();
        }
        return offHeapUsedSize;
    }

    @Override
    public long getTotalAllocatedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long totalAllocatedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            totalAllocatedSize += rm.getTotalAllocatedSize();
        }
        return totalAllocatedSize;
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufferPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufferPages += rm.getUsedCheckpointBufferPages();
        }
        return usedCheckpointBufferPages;
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufferSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufferSize += rm.getUsedCheckpointBufferSize();
        }
        return usedCheckpointBufferSize;
    }

    @Override
    public long getCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long checkpointBufferSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            checkpointBufferSize += rm.getCheckpointBufferSize();
        }
        return checkpointBufferSize;
    }

    public void wal(IgniteWriteAheadLogManager wal) {
        this.wal = wal;
    }

    public void setWalSizeProvider(IgniteOutClosure<Long> walSizeProvider) {
        this.walSizeProvider = walSizeProvider;
    }

    public void onWallRollOver() {
        this.lastWalSegmentRollOverTime = U.currentTimeMillis();
    }

    public void regionMetrics(Collection<DataRegionMetrics> regionMetrics) {
        this.regionMetrics = regionMetrics;
    }

    public boolean metricsEnabled() {
        return this.metricsEnabled;
    }

    public void onCheckpoint(long lockWaitDuration, long markDuration, long pagesWriteDuration, long fsyncDuration, long duration, long totalPages, long dataPages, long cowPages) {
        if (this.metricsEnabled) {
            this.lastCpLockWaitDuration = lockWaitDuration;
            this.lastCpMarkDuration = markDuration;
            this.lastCpPagesWriteDuration = pagesWriteDuration;
            this.lastCpFsyncDuration = fsyncDuration;
            this.lastCpDuration = duration;
            this.lastCpTotalPages = totalPages;
            this.lastCpDataPages = dataPages;
            this.lastCpCowPages = cowPages;
            this.totalCheckpointTime.addAndGet(duration);
        }
    }

    public void onWalRecordLogged() {
        this.walLoggingRate.onHit();
    }

    public void onWalBytesWritten(int size) {
        this.walWritingRate.onHits(size);
    }

    public void onFsync(long nanoTime) {
        long microseconds = nanoTime / 1000L;
        this.walFsyncTimeDuration.onHits(microseconds);
        this.walFsyncTimeNum.onHit();
    }

    public void onBuffPollSpin(int num) {
        this.walBuffPollSpinsNum.onHits(num);
    }

    private void resetRates() {
        this.walLoggingRate = new HitRateMetrics((int)this.rateTimeInterval, this.subInts);
        this.walWritingRate = new HitRateMetrics((int)this.rateTimeInterval, this.subInts);
        this.walBuffPollSpinsNum = new HitRateMetrics((int)this.rateTimeInterval, this.subInts);
        this.walFsyncTimeDuration = new HitRateMetrics((int)this.rateTimeInterval, this.subInts);
        this.walFsyncTimeNum = new HitRateMetrics((int)this.rateTimeInterval, this.subInts);
    }
}

