/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class CacheGroupAffinityMessage
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=GridLongList.class)
    private List<GridLongList> assigns;
    @GridDirectCollection(value=GridLongList.class)
    private List<GridLongList> idealAssigns;
    @GridDirectMap(keyType=Integer.class, valueType=GridLongList.class)
    private Map<Integer, GridLongList> assignsDiff;

    public CacheGroupAffinityMessage() {
    }

    private CacheGroupAffinityMessage(List<List<ClusterNode>> assign0, List<List<ClusterNode>> idealAssign0, Map<Integer, List<Long>> assignDiff0) {
        if (assign0 != null) {
            this.assigns = this.createAssigns(assign0);
        }
        if (idealAssign0 != null) {
            this.idealAssigns = this.createAssigns(idealAssign0);
        }
        if (assignDiff0 != null) {
            this.assignsDiff = U.newHashMap(assignDiff0.size());
            for (Map.Entry<Integer, List<Long>> e : assignDiff0.entrySet()) {
                List<Long> orders = e.getValue();
                GridLongList l = new GridLongList(orders.size());
                for (int n = 0; n < orders.size(); ++n) {
                    l.add(orders.get(n));
                }
                this.assignsDiff.put(e.getKey(), l);
            }
        }
    }

    private List<GridLongList> createAssigns(List<List<ClusterNode>> assign0) {
        if (assign0 != null) {
            ArrayList<GridLongList> assigns = new ArrayList<GridLongList>(assign0.size());
            for (int i = 0; i < assign0.size(); ++i) {
                List<ClusterNode> nodes = assign0.get(i);
                GridLongList l = new GridLongList(nodes.size());
                for (int n = 0; n < nodes.size(); ++n) {
                    l.add(nodes.get(n).order());
                }
                assigns.add(l);
            }
            return assigns;
        }
        return null;
    }

    public static Map<Integer, CacheGroupAffinityMessage> createAffinityDiffMessages(Map<Integer, Map<Integer, List<Long>>> affDiff) {
        if (F.isEmpty(affDiff)) {
            return null;
        }
        HashMap<Integer, CacheGroupAffinityMessage> map = U.newHashMap(affDiff.size());
        for (Map.Entry<Integer, Map<Integer, List<Long>>> e : affDiff.entrySet()) {
            map.put(e.getKey(), new CacheGroupAffinityMessage(null, null, e.getValue()));
        }
        return map;
    }

    static Map<Integer, CacheGroupAffinityMessage> createAffinityMessages(GridCacheSharedContext cctx, AffinityTopologyVersion topVer, Collection<Integer> affReq, @Nullable Map<Integer, CacheGroupAffinityMessage> cachesAff) {
        assert (!F.isEmpty(affReq)) : affReq;
        if (cachesAff == null) {
            cachesAff = U.newHashMap(affReq.size());
        }
        for (Integer grpId : affReq) {
            if (cachesAff.containsKey(grpId)) continue;
            GridAffinityAssignmentCache aff = cctx.affinity().groupAffinity(grpId);
            if (aff == null) {
                CacheGroupContext grp = cctx.cache().cacheGroup(grpId);
                assert (grp != null) : "No cache group holder or cache group to create AffinityMessage. Requested group id: " + grpId + ". Topology version: " + topVer;
                aff = grp.affinity();
            }
            List<List<ClusterNode>> assign = aff.readyAssignments(topVer);
            CacheGroupAffinityMessage msg = new CacheGroupAffinityMessage(assign, aff.centralizedAffinityFunction() ? aff.idealAssignment() : null, null);
            cachesAff.put(grpId, msg);
        }
        return cachesAff;
    }

    public static List<ClusterNode> toNodes(GridLongList assign, Map<Long, ClusterNode> nodesByOrder, DiscoCache discoCache) {
        ArrayList<ClusterNode> assign0 = new ArrayList<ClusterNode>(assign.size());
        for (int n = 0; n < assign.size(); ++n) {
            long order = assign.get(n);
            ClusterNode affNode = nodesByOrder.get(order);
            if (affNode == null) {
                affNode = discoCache.serverNodeByOrder(order);
                assert (affNode != null) : "Failed to find node by order [order=" + order + ", topVer=" + discoCache.version() + ']';
                nodesByOrder.put(order, affNode);
            }
            assign0.add(affNode);
        }
        return assign0;
    }

    @Nullable
    public List<List<ClusterNode>> createIdealAssignments(Map<Long, ClusterNode> nodesByOrder, DiscoCache discoCache) {
        if (this.idealAssigns == null) {
            return null;
        }
        return this.createAssignments(this.idealAssigns, nodesByOrder, discoCache);
    }

    public List<List<ClusterNode>> createAssignments(Map<Long, ClusterNode> nodesByOrder, DiscoCache discoCache) {
        return this.createAssignments(this.assigns, nodesByOrder, discoCache);
    }

    private List<List<ClusterNode>> createAssignments(List<GridLongList> assigns, Map<Long, ClusterNode> nodesByOrder, DiscoCache discoCache) {
        ArrayList<List<ClusterNode>> assignments0 = new ArrayList<List<ClusterNode>>(assigns.size());
        for (int p = 0; p < assigns.size(); ++p) {
            GridLongList assign = assigns.get(p);
            assignments0.add(CacheGroupAffinityMessage.toNodes(assign, nodesByOrder, discoCache));
        }
        return assignments0;
    }

    public Map<Integer, GridLongList> assignmentsDiff() {
        return this.assignsDiff;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("assigns", this.assigns, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMap("assignsDiff", this.assignsDiff, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeCollection("idealAssigns", this.idealAssigns, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.assigns = (List)reader.readCollection("assigns", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.assignsDiff = reader.readMap("assignsDiff", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.idealAssigns = (List)reader.readCollection("idealAssigns", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheGroupAffinityMessage.class);
    }

    @Override
    public short directType() {
        return 128;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(CacheGroupAffinityMessage.class, this);
    }
}

