/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridInvokeValue
implements Message {
    private static final long serialVersionUID = 1L;
    @GridDirectTransient
    private Object[] invokeArgs;
    private byte[] invokeArgsBytes;
    @GridDirectTransient
    private EntryProcessor<Object, Object, Object> entryProcessor;
    private byte[] entryProcessorBytes;

    public GridInvokeValue() {
    }

    public GridInvokeValue(EntryProcessor<Object, Object, Object> entryProcessor, Object[] invokeArgs) {
        this.invokeArgs = invokeArgs;
        this.entryProcessor = entryProcessor;
    }

    public Object[] invokeArgs() {
        return this.invokeArgs;
    }

    public EntryProcessor<Object, Object, Object> entryProcessor() {
        return this.entryProcessor;
    }

    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        if (this.entryProcessor != null && this.entryProcessorBytes == null) {
            this.entryProcessorBytes = CU.marshal(ctx, this.entryProcessor);
        }
        if (this.invokeArgsBytes == null) {
            this.invokeArgsBytes = CU.marshal(ctx, this.invokeArgs);
        }
    }

    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.entryProcessorBytes != null && this.entryProcessor == null) {
            this.entryProcessor = (EntryProcessor)U.unmarshal(ctx, this.entryProcessorBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.invokeArgs == null) {
            this.invokeArgs = (Object[])U.unmarshal(ctx, this.invokeArgsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("entryProcessorBytes", this.entryProcessorBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("invokeArgsBytes", this.invokeArgsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.entryProcessorBytes = reader.readByteArray("entryProcessorBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.invokeArgsBytes = reader.readByteArray("invokeArgsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridInvokeValue.class);
    }

    @Override
    public short directType() {
        return 161;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }
}

