/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class InitNewPageRecord
extends PageDeltaRecord {
    protected int ioType;
    protected int ioVer;
    @GridToStringExclude
    protected long newPageId;

    public InitNewPageRecord(int grpId, long pageId, int ioType, int ioVer, long newPageId) {
        super(grpId, pageId);
        this.ioType = ioType;
        this.ioVer = ioVer;
        this.newPageId = newPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        Object io = PageIO.getPageIO(this.ioType, this.ioVer);
        ((PageIO)io).initNewPage(pageAddr, this.newPageId, pageMem.realPageSize(this.groupId()));
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.INIT_NEW_PAGE_RECORD;
    }

    public int ioVersion() {
        return this.ioVer;
    }

    public int ioType() {
        return this.ioType;
    }

    public long newPageId() {
        return this.newPageId;
    }

    @Override
    public String toString() {
        return S.toString(InitNewPageRecord.class, this, "newPageId", U.hexLong(this.newPageId), "super", super.toString());
    }
}

