/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.job.GridJobWorker;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridJobContextImpl
implements ComputeJobContext,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteUuid jobId;
    private GridJobWorker job;
    private volatile GridTimeoutObject timeoutObj;
    private final Object mux = new Object();
    @GridToStringInclude
    private Map<Object, Object> attrs;

    public GridJobContextImpl() {
    }

    public GridJobContextImpl(@Nullable GridKernalContext ctx, IgniteUuid jobId) {
        assert (jobId != null);
        this.ctx = ctx;
        this.jobId = jobId;
        this.attrs = U.newHashMap(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridJobContextImpl(GridKernalContext ctx, IgniteUuid jobId, Map<? extends Serializable, ? extends Serializable> attrs) {
        this(ctx, jobId);
        Object object = this.mux;
        synchronized (object) {
            this.attrs.putAll(attrs);
        }
    }

    public void job(GridJobWorker job) {
        assert (job != null);
        this.job = job;
    }

    @Override
    public IgniteUuid getJobId() {
        return this.jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Object key, @Nullable Object val) {
        A.notNull(key, "key");
        Object object = this.mux;
        synchronized (object) {
            this.attrs.put(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map<?, ?> attrs) {
        A.notNull(attrs, "attrs");
        Object object = this.mux;
        synchronized (object) {
            this.attrs.putAll(attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> V getAttribute(K key) {
        A.notNull(key, "key");
        Object object = this.mux;
        synchronized (object) {
            return (V)this.attrs.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Object> getAttributes() {
        Object object = this.mux;
        synchronized (object) {
            return this.attrs.isEmpty() ? Collections.emptyMap() : U.sealMap(this.attrs);
        }
    }

    @Override
    public boolean heldcc() {
        if (this.ctx == null) {
            return false;
        }
        if (this.job == null) {
            this.job = this.ctx.job().activeJob(this.jobId);
        }
        return this.job != null && this.job.held();
    }

    @Override
    public <T> T holdcc() {
        return this.holdcc(0L);
    }

    @Override
    public <T> T holdcc(long timeout) {
        if (this.ctx != null) {
            if (this.job == null) {
                this.job = this.ctx.job().activeJob(this.jobId);
            }
            if (this.job != null) {
                if (!this.job.hold()) {
                    throw new IllegalStateException("Job has already been hold [ctx=" + this + ']');
                }
                assert (this.timeoutObj == null);
                if (timeout <= 0L) {
                    return null;
                }
                final long endTime = U.currentTimeMillis() + timeout;
                if (endTime > 0L) {
                    this.timeoutObj = new GridTimeoutObject(){
                        private final IgniteUuid id = IgniteUuid.randomUuid();

                        @Override
                        public IgniteUuid timeoutId() {
                            return this.id;
                        }

                        @Override
                        public long endTime() {
                            return endTime;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onTimeout() {
                            try {
                                ExecutorService execSvc;
                                Object object = GridJobContextImpl.this.mux;
                                synchronized (object) {
                                    GridTimeoutObject timeoutObj0 = GridJobContextImpl.this.timeoutObj;
                                    if (timeoutObj0 == null || timeoutObj0.timeoutId() != this.id) {
                                        return;
                                    }
                                    GridJobContextImpl.this.timeoutObj = null;
                                }
                                ExecutorService executorService = execSvc = GridJobContextImpl.this.job.isInternal() ? GridJobContextImpl.this.ctx.getManagementExecutorService() : GridJobContextImpl.this.ctx.getExecutorService();
                                assert (execSvc != null);
                                execSvc.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        GridJobContextImpl.this.callcc0();
                                    }
                                });
                            }
                            catch (RejectedExecutionException e) {
                                U.error(GridJobContextImpl.this.log(), "Failed to execute job (will execute synchronously).", e);
                                GridJobContextImpl.this.callcc0();
                            }
                        }
                    };
                    this.ctx.timeout().addTimeoutObject(this.timeoutObj);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callcc() {
        Object object = this.mux;
        synchronized (object) {
            GridTimeoutObject timeoutObj0 = this.timeoutObj;
            if (timeoutObj0 != null) {
                if (this.ctx != null) {
                    this.ctx.timeout().removeTimeoutObject(timeoutObj0);
                }
                this.timeoutObj = null;
            }
        }
        this.callcc0();
    }

    private void callcc0() {
        if (this.ctx != null) {
            if (this.job == null) {
                this.job = this.ctx.job().activeJob(this.jobId);
            }
            if (this.job != null) {
                this.job.execute();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
        U.writeGridUuid(out, this.jobId);
        U.writeMap(out, this.getAttributes());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridKernalContext)in.readObject();
        this.jobId = U.readGridUuid(in);
        this.attrs = U.readMap(in);
    }

    private IgniteLogger log() {
        assert (this.ctx != null);
        if (log == null) {
            log = U.logger(this.ctx, logRef, GridJobContextImpl.class);
        }
        return log;
    }

    public String toString() {
        return S.toString(GridJobContextImpl.class, this);
    }
}

