/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.tree.randomforest.data.NodeId;

public class TreeNode
implements Model<Vector, Double>,
Serializable {
    private static final long serialVersionUID = -8546263332508653661L;
    private final NodeId id;
    private int featureId;
    private double val;
    private Type type;
    private double impurity;
    private int depth;
    private TreeNode left;
    private TreeNode right;

    public TreeNode(long id, int treeId) {
        this.id = new NodeId(treeId, id);
        this.val = -1.0;
        this.type = Type.UNKNOWN;
        this.impurity = Double.POSITIVE_INFINITY;
        this.depth = 1;
    }

    @Override
    public Double apply(Vector features) {
        assert (this.type != Type.UNKNOWN);
        if (this.type == Type.LEAF) {
            return this.val;
        }
        if (features.get(this.featureId) <= this.val) {
            return this.left.apply(features);
        }
        return this.right.apply(features);
    }

    public NodeId predictNextNodeKey(Vector features) {
        switch (this.type) {
            case UNKNOWN: {
                return this.id;
            }
            case LEAF: {
                return this.id;
            }
        }
        if (features.get(this.featureId) <= this.val) {
            return this.left.predictNextNodeKey(features);
        }
        return this.right.predictNextNodeKey(features);
    }

    public List<TreeNode> toConditional(int featureId, double val) {
        assert (this.type == Type.UNKNOWN);
        this.toLeaf(val);
        this.left = new TreeNode(2L * this.id.nodeId(), this.id.treeId());
        this.right = new TreeNode(2L * this.id.nodeId() + 1L, this.id.treeId());
        this.type = Type.CONDITIONAL;
        this.featureId = featureId;
        this.left.depth = this.right.depth = this.depth + 1;
        return Arrays.asList(this.left, this.right);
    }

    public void toLeaf(double val) {
        assert (this.type == Type.UNKNOWN);
        this.val = val;
        this.type = Type.LEAF;
        this.left = null;
        this.right = null;
    }

    public NodeId getId() {
        return this.id;
    }

    public void setVal(double val) {
        this.val = val;
    }

    public Type getType() {
        return this.type;
    }

    public void setImpurity(double impurity) {
        this.impurity = impurity;
    }

    public double getImpurity() {
        return this.impurity;
    }

    public int getDepth() {
        return this.depth;
    }

    public TreeNode getLeft() {
        return this.left;
    }

    public TreeNode getRight() {
        return this.right;
    }

    public static enum Type {
        UNKNOWN,
        LEAF,
        CONDITIONAL;

    }
}

