/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures.partition;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.structures.partition.LabelPartitionDataOnHeap;

public class LabelPartitionDataBuilderOnHeap<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, LabelPartitionDataOnHeap> {
    private static final long serialVersionUID = -7820760153954269227L;
    private final IgniteBiFunction<K, V, Double> yExtractor;

    public LabelPartitionDataBuilderOnHeap(IgniteBiFunction<K, V, Double> yExtractor) {
        this.yExtractor = yExtractor;
    }

    @Override
    public LabelPartitionDataOnHeap build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[] y = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            y[ptr] = (Double)this.yExtractor.apply(entry.getKey(), entry.getValue());
            ++ptr;
        }
        return new LabelPartitionDataOnHeap(y);
    }
}

