/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric;

import java.util.Iterator;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.metric.Metric;

public class Recall<L>
implements Metric<L> {
    private L clsLb;

    @Override
    public double score(Iterator<LabelPair<L>> it) {
        if (this.clsLb != null) {
            long tp = 0L;
            long fn = 0L;
            while (it.hasNext()) {
                LabelPair<L> e = it.next();
                L prediction = e.getPrediction();
                L truth = e.getTruth();
                if (!this.clsLb.equals(truth)) continue;
                if (prediction.equals(truth)) {
                    ++tp;
                    continue;
                }
                ++fn;
            }
            long denominator = tp + fn;
            if (denominator == 0L) {
                return 1.0;
            }
            return (double)tp / (double)denominator;
        }
        return Double.NaN;
    }

    public Recall(L clsLb) {
        this.clsLb = clsLb;
    }
}

