/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.cursor;

import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.cursor.LabelPairCursor;
import org.jetbrains.annotations.NotNull;

public class CacheBasedLabelPairCursor<L, K, V>
implements LabelPairCursor<L> {
    private final QueryCursor<Cache.Entry<K, V>> cursor;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;
    private final IgniteBiFunction<K, V, L> lbExtractor;
    private final Model<Vector, L> mdl;

    public CacheBasedLabelPairCursor(IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor, Model<Vector, L> mdl) {
        this.cursor = this.query(upstreamCache, filter);
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
        this.mdl = mdl;
    }

    public CacheBasedLabelPairCursor(IgniteCache<K, V> upstreamCache, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor, Model<Vector, L> mdl) {
        this.cursor = this.query(upstreamCache);
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
        this.mdl = mdl;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    @NotNull
    public Iterator<LabelPair<L>> iterator() {
        return new TruthWithPredictionIterator(this.cursor.iterator());
    }

    private QueryCursor<Cache.Entry<K, V>> query(IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter) {
        ScanQuery qry = new ScanQuery();
        qry.setFilter(filter);
        return upstreamCache.query((Query)qry);
    }

    private QueryCursor<Cache.Entry<K, V>> query(IgniteCache<K, V> upstreamCache) {
        ScanQuery qry = new ScanQuery();
        return upstreamCache.query((Query)qry);
    }

    private class TruthWithPredictionIterator
    implements Iterator<LabelPair<L>> {
        private final Iterator<Cache.Entry<K, V>> iter;

        public TruthWithPredictionIterator(Iterator<Cache.Entry<K, V>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public LabelPair<L> next() {
            Cache.Entry entry = this.iter.next();
            Vector features = (Vector)CacheBasedLabelPairCursor.this.featureExtractor.apply(entry.getKey(), entry.getValue());
            Object lb = CacheBasedLabelPairCursor.this.lbExtractor.apply(entry.getKey(), entry.getValue());
            return new LabelPair(lb, CacheBasedLabelPairCursor.this.mdl.apply(features));
        }
    }
}

