/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.cv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CrossValidationResult {
    private Map<String, Double> bestHyperParams;
    private double[] bestScore;
    private Map<Map<String, Double>, double[]> scoringBoard = new HashMap<Map<String, Double>, double[]>();

    CrossValidationResult() {
    }

    public double getBest(String hyperParamName) {
        return this.bestHyperParams.get(hyperParamName);
    }

    public double[] getBestScore() {
        return this.bestScore;
    }

    void addScores(double[] locScores, Map<String, Double> paramMap) {
        this.scoringBoard.put(paramMap, locScores);
    }

    public double getBestAvgScore() {
        if (this.bestScore == null) {
            return Double.MIN_VALUE;
        }
        return Arrays.stream(this.bestScore).average().orElse(Double.MIN_VALUE);
    }

    void setBestScore(double[] bestScore) {
        this.bestScore = bestScore;
    }

    void setBestHyperParams(Map<String, Double> bestHyperParams) {
        this.bestHyperParams = bestHyperParams;
    }

    public Map<Map<String, Double>, double[]> getScoringBoard() {
        return this.scoringBoard;
    }

    public Map<String, Double> getBestHyperParams() {
        return this.bestHyperParams;
    }

    public String toString() {
        return "CrossValidationResult{bestHyperParams=" + this.bestHyperParams + ", bestScore=" + Arrays.toString(this.bestScore) + '}';
    }
}

