/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.regressions.logistic.multiclass;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.regressions.logistic.binomial.LogisticRegressionModel;

public class LogRegressionMultiClassModel
implements Model<Vector, Double>,
Exportable<LogRegressionMultiClassModel>,
Serializable {
    private static final long serialVersionUID = -114986533350117L;
    private Map<Double, LogisticRegressionModel> models = new HashMap<Double, LogisticRegressionModel>();

    @Override
    public Double apply(Vector input) {
        TreeMap maxMargins = new TreeMap();
        this.models.forEach((k, v) -> maxMargins.put(1.0 / (1.0 + Math.exp(-(input.dot(v.weights()) + v.intercept()))), k));
        return (Double)maxMargins.lastEntry().getValue();
    }

    @Override
    public <P> void saveModel(Exporter<LogRegressionMultiClassModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogRegressionMultiClassModel mdl = (LogRegressionMultiClassModel)o;
        return Objects.equals(this.models, mdl.models);
    }

    public int hashCode() {
        return Objects.hash(this.models);
    }

    public String toString() {
        StringBuilder wholeStr = new StringBuilder();
        this.models.forEach((clsLb, mdl) -> wholeStr.append("The class with label ").append(clsLb).append(" has classifier: ").append(mdl.toString()).append(System.lineSeparator()));
        return wholeStr.toString();
    }

    @Override
    public String toString(boolean pretty) {
        return this.toString();
    }

    public void add(double clsLb, LogisticRegressionModel mdl) {
        this.models.put(clsLb, mdl);
    }

    public Optional<LogisticRegressionModel> getModel(Double clsLb) {
        return Optional.ofNullable(this.models.get(clsLb));
    }
}

