/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.minmaxscaling;

import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class MinMaxScalerPreprocessor<K, V>
implements IgniteBiFunction<K, V, Vector> {
    private static final long serialVersionUID = 6997800576392623469L;
    private final double[] min;
    private final double[] max;
    private final IgniteBiFunction<K, V, Vector> basePreprocessor;

    public MinMaxScalerPreprocessor(double[] min, double[] max, IgniteBiFunction<K, V, Vector> basePreprocessor) {
        this.min = min;
        this.max = max;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public Vector apply(K k, V v) {
        Vector res = (Vector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.min.length);
        assert (res.size() == this.max.length);
        for (int i = 0; i < res.size(); ++i) {
            res.set(i, (res.get(i) - this.min[i]) / (this.max[i] - this.min[i]));
        }
        return res;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }
}

