/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.pipeline;

import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class PipelineMdl<K, V>
implements Model<Vector, Double> {
    private Model<Vector, Double> internalMdl;
    private IgniteBiFunction<K, V, Vector> featureExtractor;
    private IgniteBiFunction<K, V, Double> lbExtractor;

    @Override
    public Double apply(Vector vector) {
        return (Double)this.internalMdl.apply(vector);
    }

    public IgniteBiFunction<K, V, Vector> getFeatureExtractor() {
        return this.featureExtractor;
    }

    public IgniteBiFunction<K, V, Double> getLabelExtractor() {
        return this.lbExtractor;
    }

    public Model<Vector, Double> getInternalMdl() {
        return this.internalMdl;
    }

    public PipelineMdl<K, V> withInternalMdl(Model<Vector, Double> internalMdl) {
        this.internalMdl = internalMdl;
        return this;
    }

    public PipelineMdl<K, V> withFeatureExtractor(IgniteBiFunction featureExtractor) {
        this.featureExtractor = featureExtractor;
        return this;
    }

    public PipelineMdl<K, V> withLabelExtractor(IgniteBiFunction<K, V, Double> lbExtractor) {
        this.lbExtractor = lbExtractor;
        return this;
    }

    public String toString() {
        return "PipelineMdl{internalMdl=" + this.internalMdl + '}';
    }
}

