/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.pipeline.PipelineMdl;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.trainers.DatasetTrainer;

public class Pipeline<K, V, R> {
    private IgniteBiFunction<K, V, R> finalFeatureExtractor;
    private IgniteBiFunction<K, V, Double> lbExtractor;
    private List<PreprocessingTrainer> preprocessors = new ArrayList<PreprocessingTrainer>();
    private DatasetTrainer finalStage;

    public Pipeline<K, V, R> addFeatureExtractor(IgniteBiFunction<K, V, R> featureExtractor) {
        this.finalFeatureExtractor = featureExtractor;
        return this;
    }

    public Pipeline<K, V, R> addLabelExtractor(IgniteBiFunction<K, V, Double> lbExtractor) {
        this.lbExtractor = lbExtractor;
        return this;
    }

    public Pipeline<K, V, R> addPreprocessor(PreprocessingTrainer preprocessor) {
        this.preprocessors.add(preprocessor);
        return this;
    }

    public Pipeline<K, V, R> addTrainer(DatasetTrainer trainer) {
        this.finalStage = trainer;
        return this;
    }

    public PipelineMdl<K, V> fit(Ignite ignite, IgniteCache<K, V> cache) {
        CacheBasedDatasetBuilder<K, V> datasetBuilder = new CacheBasedDatasetBuilder<K, V>(ignite, cache);
        return this.fit(datasetBuilder);
    }

    public PipelineMdl<K, V> fit(Map<K, V> data, int parts) {
        LocalDatasetBuilder<K, V> datasetBuilder = new LocalDatasetBuilder<K, V>(data, parts);
        return this.fit(datasetBuilder);
    }

    private PipelineMdl<K, V> fit(DatasetBuilder datasetBuilder) {
        assert (this.lbExtractor != null);
        assert (this.finalFeatureExtractor != null);
        if (this.finalStage == null) {
            throw new IllegalStateException("The Pipeline should be finished with the Training Stage.");
        }
        this.preprocessors.forEach(e -> {
            this.finalFeatureExtractor = e.fit(datasetBuilder, this.finalFeatureExtractor);
        });
        Object internalMdl = this.finalStage.fit(datasetBuilder, this.finalFeatureExtractor, this.lbExtractor);
        return new PipelineMdl().withFeatureExtractor(this.finalFeatureExtractor).withLabelExtractor(this.lbExtractor).withInternalMdl((Model<Vector, Double>)internalMdl);
    }
}

