/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.storage;

import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class SparseVectorStorage
implements VectorStorage,
StorageConstants {
    private int size;
    private int acsMode;
    private Map<Integer, Double> sto;

    public SparseVectorStorage() {
    }

    public SparseVectorStorage(Map<Integer, Double> map, boolean cp) {
        assert (map.size() > 0);
        this.size = map.size();
        this.acsMode = map instanceof Int2DoubleRBTreeMap ? 1001 : (map instanceof Int2DoubleOpenHashMap ? 1002 : 3001);
        if (cp) {
            switch (this.acsMode) {
                case 1001: {
                    this.sto = new Int2DoubleRBTreeMap(map);
                }
                case 1002: {
                    this.sto = new Int2DoubleOpenHashMap(map);
                    break;
                }
                default: {
                    this.sto = new HashMap<Integer, Double>(map);
                    break;
                }
            }
        } else {
            this.sto = map;
        }
    }

    public SparseVectorStorage(int size, int acsMode) {
        assert (size > 0);
        this.assertAccessMode(acsMode);
        this.size = size;
        this.acsMode = acsMode;
        this.sto = acsMode == 1001 ? new Int2DoubleRBTreeMap() : new Int2DoubleOpenHashMap();
    }

    public int getAccessMode() {
        return this.acsMode;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return this.sto.getOrDefault(i, 0.0);
    }

    @Override
    public void set(int i, double v) {
        if (v != 0.0) {
            this.sto.put(i, v);
        } else if (this.sto.containsKey(i)) {
            this.sto.remove(i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.acsMode);
        out.writeObject(this.sto);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.acsMode = in.readInt();
        this.sto = (Map)in.readObject();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.acsMode == 1001;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public double[] data() {
        double[] data = new double[this.size];
        this.sto.forEach((idx, val) -> {
            data[idx.intValue()] = val;
        });
        return data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseVectorStorage that = (SparseVectorStorage)o;
        return this.size == that.size && this.acsMode == that.acsMode && (this.sto != null ? this.sto.equals(that.sto) : that.sto == null);
    }

    public int hashCode() {
        int res = this.size;
        res = 31 * res + this.acsMode;
        res = 31 * res + (this.sto != null ? this.sto.hashCode() : 0);
        return res;
    }

    public IntSet indexes() {
        return (IntSet)this.sto.keySet();
    }
}

