/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.AbstractVector;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;
import org.apache.ignite.ml.math.primitives.vector.impl.SparseVector;

public class VectorUtils {
    public static Vector zeroesLike(Vector v) {
        return v.like(v.size()).assign(0.0);
    }

    public static DenseVector zeroes(int n) {
        return (DenseVector)new DenseVector(n).assign(0.0);
    }

    public static Vector num2Vec(int num, int vecSize) {
        return VectorUtils.num2Vec(num, vecSize, false);
    }

    public static Vector num2Vec(int num, int vecSize, boolean isDistributed) {
        DenseVector res = new DenseVector(vecSize);
        return res.setX(num, 1.0);
    }

    public static double vec2Num(Vector vec) {
        int max = 0;
        double maxVal = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vec.size(); ++i) {
            double curVal = vec.getX(i);
            if (!(curVal > maxVal)) continue;
            max = i;
            maxVal = curVal;
        }
        return max;
    }

    public static Vector elementWiseTimes(Vector vec1, Vector vec2) {
        vec1.map(vec2, (a, b) -> a * b);
        return vec1;
    }

    public static Vector elementWiseMinus(Vector vec1, Vector vec2) {
        vec1.map(vec2, (a, b) -> a - b);
        return vec1;
    }

    public static Vector zipWith(Vector v1, Vector v2, IgniteBiFunction<Double, Double, Double> f) {
        int size = Math.min(v1.size(), v2.size());
        Vector res = v1.like(size);
        for (int row = 0; row < size; ++row) {
            res.setX(row, (Double)f.apply(v1.getX(row), v2.getX(row)));
        }
        return res;
    }

    public static Vector copyPart(Vector v, int off, int len) {
        assert (off >= 0);
        assert (len <= v.size());
        Vector res = v.like(len);
        for (int i = 0; i < len; ++i) {
            res.setX(i, v.getX(off + i));
        }
        return res;
    }

    public static Vector of(double ... values) {
        A.notNull((Object)values, (String)"values");
        return new DenseVector(values);
    }

    public static Vector of(Double[] values) {
        A.notNull((Object)values, (String)"values");
        AbstractVector answer = Arrays.stream(values).anyMatch(Objects::isNull) ? new SparseVector(values.length, 1002) : new DenseVector(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            answer.set(i, values[i]);
        }
        return answer;
    }
}

