/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.matrix.impl;

import org.apache.ignite.ml.math.primitives.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.matrix.OrderedMatrix;
import org.apache.ignite.ml.math.primitives.matrix.storage.DenseMatrixStorage;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;

public class DenseMatrix
extends AbstractMatrix
implements OrderedMatrix {
    public DenseMatrix() {
    }

    public DenseMatrix(int rows, int cols) {
        this(rows, cols, 2001);
    }

    public DenseMatrix(int rows, int cols, int acsMode) {
        assert (rows > 0);
        assert (cols > 0);
        this.setStorage(new DenseMatrixStorage(rows, cols, acsMode));
    }

    public DenseMatrix(double[][] mtx, int acsMode) {
        assert (mtx != null);
        this.setStorage(new DenseMatrixStorage(mtx, acsMode));
    }

    public DenseMatrix(double[][] mtx) {
        this(mtx, 2001);
    }

    public DenseMatrix(double[] mtx, int rows, int acsMode) {
        assert (mtx != null);
        this.setStorage(new DenseMatrixStorage(mtx, rows, acsMode));
    }

    public DenseMatrix(double[] mtx, int rows) {
        this(mtx, 2001, rows);
    }

    private DenseMatrix(DenseMatrix orig) {
        this(orig, orig.accessMode());
    }

    private DenseMatrix(DenseMatrix orig, int acsMode) {
        assert (orig != null);
        this.setStorage(new DenseMatrixStorage(orig.rowSize(), orig.columnSize(), acsMode));
        this.assign(orig);
    }

    @Override
    public Matrix copy() {
        return new DenseMatrix(this, this.accessMode());
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new DenseMatrix(rows, cols, this.getStorage() != null ? this.accessMode() : 2001);
    }

    @Override
    public Vector likeVector(int crd) {
        return new DenseVector(crd);
    }

    @Override
    public int accessMode() {
        return this.getStorage().accessMode();
    }
}

