/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.transactions.Transaction;

public class TruncateSelectionJob
extends ComputeJobAdapter {
    private Long key;
    private List<Long> mutatedGeneKeys;
    @IgniteInstanceResource
    private Ignite ignite = null;

    public TruncateSelectionJob(Long key, List<Long> mutatedGeneKeys) {
        this.key = key;
        this.mutatedGeneKeys = mutatedGeneKeys;
    }

    public Boolean execute() throws IgniteException {
        IgniteCache populationCache = this.ignite.cache("populationCache");
        Chromosome chromosome = (Chromosome)populationCache.localPeek((Object)this.key, new CachePeekMode[0]);
        long[] geneKeys = chromosome.getGenes();
        for (int k = 0; k < this.mutatedGeneKeys.size(); ++k) {
            geneKeys[k] = this.mutatedGeneKeys.get(k);
        }
        chromosome.setGenes(geneKeys);
        Transaction tx = this.ignite.transactions().txStart();
        populationCache.put((Object)chromosome.id(), (Object)chromosome);
        tx.commit();
        return Boolean.TRUE;
    }
}

