/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment;

import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.environment.logging.NoOpLogger;
import org.apache.ignite.ml.environment.parallelism.DefaultParallelismStrategy;
import org.apache.ignite.ml.environment.parallelism.NoParallelismStrategy;
import org.apache.ignite.ml.environment.parallelism.ParallelismStrategy;

public class LearningEnvironmentBuilder {
    private ParallelismStrategy parallelismStgy = NoParallelismStrategy.INSTANCE;
    private MLLogger.Factory loggingFactory = NoOpLogger.factory();

    LearningEnvironmentBuilder() {
    }

    public <T> LearningEnvironmentBuilder withParallelismStrategy(ParallelismStrategy stgy) {
        this.parallelismStgy = stgy;
        return this;
    }

    public LearningEnvironmentBuilder withParallelismStrategy(ParallelismStrategy.Type stgyType) {
        switch (stgyType) {
            case NO_PARALLELISM: {
                this.parallelismStgy = NoParallelismStrategy.INSTANCE;
                break;
            }
            case ON_DEFAULT_POOL: {
                this.parallelismStgy = new DefaultParallelismStrategy();
            }
        }
        return this;
    }

    public LearningEnvironmentBuilder withLoggingFactory(MLLogger.Factory loggingFactory) {
        this.loggingFactory = loggingFactory;
        return this;
    }

    public LearningEnvironment build() {
        return new LearningEnvironmentImpl(this.parallelismStgy, this.loggingFactory);
    }

    private class LearningEnvironmentImpl
    implements LearningEnvironment {
        private final ParallelismStrategy parallelismStgy;
        private final MLLogger.Factory loggingFactory;

        private LearningEnvironmentImpl(ParallelismStrategy parallelismStgy, MLLogger.Factory loggingFactory) {
            this.parallelismStgy = parallelismStgy;
            this.loggingFactory = loggingFactory;
        }

        @Override
        public ParallelismStrategy parallelismStrategy() {
            return this.parallelismStgy;
        }

        @Override
        public MLLogger logger() {
            return this.loggingFactory.create(this.getClass());
        }

        @Override
        public <T> MLLogger logger(Class<T> clazz) {
            return this.loggingFactory.create(clazz);
        }
    }
}

