/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.primitive;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.FeatureMatrixWithLabelsOnHeapData;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class FeatureMatrixWithLabelsOnHeapDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, FeatureMatrixWithLabelsOnHeapData> {
    private static final long serialVersionUID = 6273736987424171813L;
    private final IgniteBiFunction<K, V, Vector> featureExtractor;
    private final IgniteBiFunction<K, V, Double> lbExtractor;

    public FeatureMatrixWithLabelsOnHeapDataBuilder(IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, Double> lbExtractor) {
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
    }

    @Override
    public FeatureMatrixWithLabelsOnHeapData build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[][] features = new double[Math.toIntExact(upstreamDataSize)][];
        double[] labels = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            features[ptr] = ((Vector)this.featureExtractor.apply(entry.getKey(), entry.getValue())).asArray();
            labels[ptr] = (Double)this.lbExtractor.apply(entry.getKey(), entry.getValue());
            ++ptr;
        }
        return new FeatureMatrixWithLabelsOnHeapData(features, labels);
    }
}

