/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.config;

import com.google.common.collect.ImmutableList;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.TlsVersion;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.docker.suppliers.DockerSSLContextSupplier;
import org.jclouds.http.okhttp.OkHttpClientSupplier;

@Singleton
public class DockerOkHttpClientSupplier
implements OkHttpClientSupplier {
    private final DockerSSLContextSupplier dockerSSLContextSupplier;

    @Inject
    DockerOkHttpClientSupplier(DockerSSLContextSupplier dockerSSLContextSupplier) {
        this.dockerSSLContextSupplier = dockerSSLContextSupplier;
    }

    public OkHttpClient get() {
        OkHttpClient client = new OkHttpClient();
        ConnectionSpec tlsSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_0, TlsVersion.TLS_1_1, TlsVersion.TLS_1_2}).build();
        ConnectionSpec cleartextSpec = new ConnectionSpec.Builder(ConnectionSpec.CLEARTEXT).build();
        client.setConnectionSpecs((List)ImmutableList.of((Object)tlsSpec, (Object)cleartextSpec));
        client.setSslSocketFactory(this.dockerSSLContextSupplier.get().getSocketFactory());
        return client;
    }
}

