/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.ContainerSummary;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.domain.ImageSummary;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.options.RemoveContainerOptions;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class DockerComputeServiceAdapter
implements ComputeServiceAdapter<Container, Hardware, Image, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DockerApi api;

    @Inject
    public DockerComputeServiceAdapter(DockerApi api) {
        this.api = (DockerApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Container> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template was null");
        TemplateOptions options = template.getOptions();
        Preconditions.checkNotNull((Object)options, (Object)"template options was null");
        String imageId = (String)Preconditions.checkNotNull((Object)template.getImage().getId(), (Object)"template image id must not be null");
        String loginUser = template.getImage().getDefaultCredentials().getUser();
        String loginUserPassword = (String)template.getImage().getDefaultCredentials().getOptionalPassword().or((Object)"password");
        DockerTemplateOptions templateOptions = (DockerTemplateOptions)DockerTemplateOptions.class.cast(options);
        Config.Builder containerConfigBuilder = templateOptions.getConfigBuilder();
        if (containerConfigBuilder == null) {
            containerConfigBuilder = Config.builder();
            containerConfigBuilder.entrypoint(templateOptions.getEntrypoint());
            containerConfigBuilder.cmd(templateOptions.getCommands());
            containerConfigBuilder.memory(templateOptions.getMemory());
            containerConfigBuilder.hostname(templateOptions.getHostname());
            containerConfigBuilder.cpuShares(templateOptions.getCpuShares());
            containerConfigBuilder.openStdin(templateOptions.getOpenStdin());
            containerConfigBuilder.env(templateOptions.getEnv());
            if (!templateOptions.getVolumes().isEmpty()) {
                LinkedHashMap volumes = Maps.newLinkedHashMap();
                for (String string : templateOptions.getVolumes().values()) {
                    volumes.put(string, Maps.newHashMap());
                }
                containerConfigBuilder.volumes(volumes);
            }
            HostConfig.Builder hostConfigBuilder = HostConfig.builder().publishAllPorts(true).privileged(templateOptions.getPrivileged());
            if (!templateOptions.getPortBindings().isEmpty()) {
                HashMap portBindings = Maps.newHashMap();
                for (Map.Entry<Integer, Integer> entry : templateOptions.getPortBindings().entrySet()) {
                    portBindings.put(entry.getValue() + "/tcp", Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"HostIp", (Object)"0.0.0.0", (Object)"HostPort", (Object)Integer.toString(entry.getKey()))}));
                }
                hostConfigBuilder.portBindings(portBindings);
            }
            if (!templateOptions.getDns().isEmpty()) {
                hostConfigBuilder.dns(templateOptions.getDns());
            }
            if (!templateOptions.getExtraHosts().isEmpty()) {
                ArrayList extraHosts = Lists.newArrayList();
                for (Map.Entry<String, String> entry : templateOptions.getExtraHosts().entrySet()) {
                    extraHosts.add(entry.getKey() + ":" + entry.getValue());
                }
                hostConfigBuilder.extraHosts(extraHosts);
            }
            if (!templateOptions.getVolumes().isEmpty()) {
                for (Map.Entry entry : templateOptions.getVolumes().entrySet()) {
                    hostConfigBuilder.binds((List<String>)ImmutableList.of((Object)((String)entry.getKey() + ":" + (String)entry.getValue())));
                }
            }
            if (!templateOptions.getVolumesFrom().isEmpty()) {
                hostConfigBuilder.volumesFrom(templateOptions.getVolumesFrom());
            }
            hostConfigBuilder.networkMode(templateOptions.getNetworkMode());
            containerConfigBuilder.hostConfig(hostConfigBuilder.build());
        }
        containerConfigBuilder.image(imageId);
        Config containerConfig = containerConfigBuilder.build();
        HashMap exposedPorts = Maps.newHashMap();
        if (containerConfig.exposedPorts() == null) {
            exposedPorts.putAll(containerConfig.exposedPorts());
        }
        for (int inboundPort : templateOptions.getInboundPorts()) {
            String portKey = inboundPort + "/tcp";
            if (exposedPorts.containsKey(portKey)) continue;
            exposedPorts.put(portKey, Maps.newHashMap());
        }
        containerConfigBuilder.exposedPorts(exposedPorts);
        containerConfig = containerConfigBuilder.build();
        HashMap hashMap = Maps.newHashMap();
        Map<String, List<Map<String, String>>> map = containerConfig.hostConfig().portBindings();
        if (map != null) {
            hashMap.putAll(map);
        }
        for (String exposedPort : containerConfig.exposedPorts().keySet()) {
            if (hashMap.containsKey(exposedPort)) continue;
            hashMap.put(exposedPort, Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"HostIp", (Object)"0.0.0.0")}));
        }
        HostConfig.Builder hostConfigBuilder = HostConfig.builder().fromHostConfig(containerConfig.hostConfig());
        hostConfigBuilder.portBindings(hashMap);
        containerConfigBuilder.hostConfig(hostConfigBuilder.build());
        containerConfig = containerConfigBuilder.build();
        this.logger.debug(">> creating new container with containerConfig(%s)", new Object[]{containerConfig});
        Container container = this.api.getContainerApi().createContainer(name, containerConfig);
        this.logger.trace("<< container(%s)", new Object[]{container.id()});
        HostConfig hostConfig = containerConfig.hostConfig();
        this.api.getContainerApi().startContainer(container.id(), hostConfig);
        container = this.api.getContainerApi().inspectContainer(container.id());
        if (container.state().exitCode() != 0) {
            this.destroyNode(container.id());
            throw new IllegalStateException(String.format("Container %s has not started correctly", container.id()));
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)container, container.id(), LoginCredentials.builder().user(loginUser).password(loginUserPassword).build());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        LinkedHashSet hardware = Sets.newLinkedHashSet();
        hardware.add(new HardwareBuilder().ids("micro").hypervisor("lxc").name("micro").processor(new Processor(1.0, 1.0)).ram(512).build());
        hardware.add(new HardwareBuilder().ids("small").hypervisor("lxc").name("small").processor(new Processor(1.0, 1.0)).ram(1024).build());
        hardware.add(new HardwareBuilder().ids("medium").hypervisor("lxc").name("medium").processor(new Processor(2.0, 1.0)).ram(2048).build());
        hardware.add(new HardwareBuilder().ids("large").hypervisor("lxc").name("large").processor(new Processor(2.0, 1.0)).ram(3072).build());
        return hardware;
    }

    public Set<Image> listImages() {
        HashSet images = Sets.newHashSet();
        for (ImageSummary imageSummary : this.api.getImageApi().listImages()) {
            Image inspected = this.api.getImageApi().inspectImage(imageSummary.id());
            inspected = Image.create(inspected.id(), inspected.author(), inspected.comment(), inspected.config(), inspected.containerConfig(), inspected.parent(), inspected.created(), inspected.container(), inspected.dockerVersion(), inspected.architecture(), inspected.os(), inspected.size(), inspected.virtualSize(), imageSummary.repoTags());
            images.add(inspected);
        }
        return images;
    }

    public Image getImage(final String imageIdOrName) {
        Preconditions.checkNotNull((Object)imageIdOrName);
        if (imageIdOrName.startsWith("sha256")) {
            return (Image)Iterables.find((Iterable)this.listImages(), (Predicate)new Predicate<Image>(){

                public boolean apply(Image input) {
                    return input.id().equals(imageIdOrName);
                }
            }, null);
        }
        this.api.getImageApi().createImage(CreateImageOptions.Builder.fromImage(imageIdOrName));
        return (Image)Iterables.find((Iterable)this.listImages(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                for (String tag : input.repoTags()) {
                    if (!tag.equals(imageIdOrName) && !tag.equals(imageIdOrName + ":latest")) continue;
                    return true;
                }
                return false;
            }
        }, null);
    }

    public Iterable<Container> listNodes() {
        HashSet containers = Sets.newHashSet();
        for (ContainerSummary containerSummary : this.api.getContainerApi().listContainers(ListContainerOptions.Builder.all(true))) {
            containers.add(this.api.getContainerApi().inspectContainer(containerSummary.id()));
        }
        return containers;
    }

    public Iterable<Container> listNodesByIds(Iterable<String> ids) {
        HashSet containers = Sets.newHashSet();
        for (String id : ids) {
            containers.add(this.api.getContainerApi().inspectContainer(id));
        }
        return containers;
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public Container getNode(String id) {
        return this.api.getContainerApi().inspectContainer(id);
    }

    public void destroyNode(String id) {
        this.api.getContainerApi().removeContainer(id, RemoveContainerOptions.Builder.force(true));
    }

    public void rebootNode(String id) {
        this.api.getContainerApi().stopContainer(id);
        this.api.getContainerApi().startContainer(id);
    }

    public void resumeNode(String id) {
        this.api.getContainerApi().unpause(id);
    }

    public void suspendNode(String id) {
        this.api.getContainerApi().pause(id);
    }
}

