/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetachedEnvironment
extends ContextEnvironment {
    private FlinkPlan detachedPlan;
    private static final Logger LOG = LoggerFactory.getLogger(DetachedEnvironment.class);

    public DetachedEnvironment(ClusterClient remoteConnection, List<URL> jarFiles, List<URL> classpaths, ClassLoader userCodeClassLoader, SavepointRestoreSettings savepointSettings) {
        super(remoteConnection, jarFiles, classpaths, userCodeClassLoader, savepointSettings);
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        Plan p = this.createProgramPlan(jobName);
        this.setDetachedPlan((FlinkPlan)ClusterClient.getOptimizedPlan(this.client.compiler, p, this.getParallelism()));
        LOG.warn("Job was executed in detached mode, the results will be available on completion.");
        this.lastJobExecutionResult = DetachedJobExecutionResult.INSTANCE;
        return this.lastJobExecutionResult;
    }

    public void setDetachedPlan(FlinkPlan plan) {
        if (this.detachedPlan != null) {
            throw new InvalidProgramException("Job was submitted in detached mode. Only one call to execute is allowed. ");
        }
        this.detachedPlan = plan;
    }

    JobSubmissionResult finalizeExecute() throws ProgramInvocationException {
        return this.client.run(this.detachedPlan, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader, this.savepointSettings);
    }

    public static final class DetachedJobExecutionResult
    extends JobExecutionResult {
        public static final DetachedJobExecutionResult INSTANCE = new DetachedJobExecutionResult();
        static final String DETACHED_MESSAGE = "Job was submitted in detached mode. ";
        static final String EXECUTE_TWICE_MESSAGE = "Only one call to execute is allowed. ";
        static final String EAGER_FUNCTION_MESSAGE = "Please make sure your program doesn't call an eager execution function [collect, print, printToErr, count]. ";
        static final String JOB_RESULT_MESSAGE = "Results of job execution, such as accumulators, runtime, job id etc. are not available. ";

        private DetachedJobExecutionResult() {
            super(null, -1L, null);
        }

        public long getNetRuntime() {
            throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, job id etc. are not available. ");
        }

        public <T> T getAccumulatorResult(String accumulatorName) {
            throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, job id etc. are not available. Please make sure your program doesn't call an eager execution function [collect, print, printToErr, count]. ");
        }

        public Map<String, Object> getAllAccumulatorResults() {
            throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, job id etc. are not available. ");
        }

        public Integer getIntCounterResult(String accumulatorName) {
            throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, job id etc. are not available. ");
        }

        public JobID getJobID() {
            throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, job id etc. are not available. ");
        }
    }
}

