/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.program.StandaloneClusterClient;
import org.apache.flink.configuration.Configuration;

public class StandaloneClusterDescriptor
implements ClusterDescriptor<StandaloneClusterClient> {
    private final Configuration config;

    public StandaloneClusterDescriptor(Configuration config) {
        this.config = config;
    }

    @Override
    public String getClusterDescription() {
        String host = this.config.getString("jobmanager.rpc.address", "");
        int port = this.config.getInteger("jobmanager.rpc.port", -1);
        return "Standalone cluster at " + host + ":" + port;
    }

    @Override
    public StandaloneClusterClient retrieve(String applicationID) {
        try {
            return new StandaloneClusterClient(this.config);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't retrieve standalone cluster", e);
        }
    }

    @Override
    public StandaloneClusterClient deploy() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can't deploy a standalone cluster.");
    }
}

