/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.zeromq;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.StreamAdapter;
import org.apache.ignite.stream.zeromq.ZeroMqTypeSocket;
import org.jetbrains.annotations.NotNull;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class IgniteZeroMqStreamer<K, V>
extends StreamAdapter<byte[], K, V>
implements AutoCloseable {
    protected IgniteLogger log;
    private volatile boolean isStarted = false;
    private ExecutorService zeroMqExSrv;
    private ZMQ.Context ctx;
    private int ioThreads;
    private int socketType;
    private String addr;
    private byte[] topic;
    private long timeout = 5000L;

    public IgniteZeroMqStreamer(int ioThreads, ZeroMqTypeSocket socketType, @NotNull String addr, byte[] topic) {
        A.ensure((ioThreads > 0 ? 1 : 0) != 0, (String)"ioThreads has to larger than 0.");
        A.ensure((!"".equals(addr) ? 1 : 0) != 0, (String)"addr cannot be empty.");
        A.ensure((socketType != null ? 1 : 0) != 0, (String)"socketType has to be specified.");
        this.ioThreads = ioThreads;
        this.addr = addr;
        this.topic = topic;
        this.socketType = socketType.getType();
    }

    public void start() {
        A.ensure((this.getSingleTupleExtractor() != null || this.getMultipleTupleExtractor() != null ? 1 : 0) != 0, (String)"ZeroMq extractor.");
        this.log = this.getIgnite().log();
        if (this.isStarted) {
            this.log.warning("Attempted to start an already started ZeroMQ streamer");
            return;
        }
        this.isStarted = true;
        this.zeroMqExSrv = Executors.newSingleThreadExecutor();
        this.ctx = ZMQ.context((int)this.ioThreads);
        this.zeroMqExSrv.execute(() -> {
            ZMQ.Socket socket = this.ctx.socket(this.socketType);
            socket.connect(this.addr);
            if (ZeroMqTypeSocket.SUB.getType() == this.socketType) {
                socket.subscribe(this.topic);
            }
            while (this.isStarted) {
                try {
                    byte[] msg = socket.recv(0);
                    if (ZeroMqTypeSocket.SUB.getType() == this.socketType && socket.hasReceiveMore()) {
                        this.addMessage(socket.recv(0));
                        continue;
                    }
                    this.addMessage(msg);
                }
                catch (ZMQException e) {
                    if (e.getErrorCode() != ZMQ.Error.ETERM.getCode()) continue;
                    break;
                }
            }
            socket.close();
        });
    }

    @Override
    public void close() throws Exception {
        this.isStarted = false;
        if (this.ctx != null) {
            this.ctx.close();
        }
        if (this.zeroMqExSrv != null) {
            this.zeroMqExSrv.shutdown();
            try {
                if (!this.zeroMqExSrv.awaitTermination(this.timeout, TimeUnit.MILLISECONDS)) {
                    this.log.warning("Timed out waiting for consumer threads to shut down, exiting uncleanly.");
                }
            }
            catch (InterruptedException ignored) {
                this.zeroMqExSrv.shutdownNow();
                this.log.error("Interrupted during shutdown, exiting uncleanly.");
            }
        }
    }
}

