/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.upload.model.Values10;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public abstract class AbstractNativeBenchmark
extends IgniteAbstractBenchmark {
    private long insertRowsCnt;
    private String cacheName;
    private IgniteCache<Long, Values10> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.cacheName = ((Object)((Object)this)).getClass().getSimpleName();
        this.insertRowsCnt = this.args.upload.uploadRowsCnt();
        long warmupRowsCnt = this.args.upload.warmupRowsCnt();
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Starting custom warmup.");
        String warmupCacheName = this.cacheName + "Warmup";
        try (IgniteCache<Long, Values10> warmupCache = this.createCache(warmupCacheName);){
            this.upload(warmupCacheName, warmupRowsCnt);
        }
        finally {
            this.ignite().destroyCache(warmupCacheName);
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Custom warmup finished.");
        this.cache = this.createCache(this.cacheName);
    }

    private IgniteCache<Long, Values10> createCache(String name) {
        CacheConfiguration cfg = new CacheConfiguration(name);
        if (this.args.atomicMode() != null) {
            cfg.setAtomicityMode(this.args.atomicMode());
        }
        return this.ignite().createCache(cfg);
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.cache == null) {
                throw new IllegalStateException("Cache is null, probably an error during setUp or warmup");
            }
            long size = this.cache.sizeLong(new CachePeekMode[0]);
            if (size != this.insertRowsCnt) {
                String msg = "Incorrect cache size: [actual=" + size + ", expected=" + this.insertRowsCnt + "].";
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("TearDown: " + msg));
                throw new RuntimeException(msg);
            }
            this.cache.close();
            this.ignite().destroyCache(this.cacheName);
        }
        catch (IgniteException ex) {
            BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Could not close or destroy cache: " + (Object)((Object)ex)));
            throw ex;
        }
        finally {
            super.tearDown();
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        this.upload(this.cacheName, this.insertRowsCnt);
        return true;
    }

    protected abstract void upload(String var1, long var2);
}

