/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.yardstick.jdbc.AbstractJdbcBenchmark;

public class JdbcSqlQueryRangeBenchmark
extends AbstractJdbcBenchmark {
    private ThreadLocal<PreparedStatement> stmtRange = this.newStatement("SELECT id, val FROM test_long WHERE id BETWEEN ? AND ?");
    private ThreadLocal<PreparedStatement> stmtSingle = this.newStatement("SELECT id, val FROM test_long WHERE id = ?");

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long expRsSize;
        PreparedStatement stmt;
        if (this.args.sqlRange() == 1) {
            stmt = this.stmtSingle.get();
            stmt.setLong(1, ThreadLocalRandom.current().nextLong(this.args.range()) + 1L);
            expRsSize = 1L;
        } else {
            stmt = this.stmtRange.get();
            long id = ThreadLocalRandom.current().nextLong(this.args.range() - this.args.sqlRange()) + 1L;
            long maxId = id + (long)this.args.sqlRange() - 1L;
            stmt.setLong(1, id);
            stmt.setLong(2, maxId);
            expRsSize = this.args.sqlRange();
        }
        long rsSize = 0L;
        try (ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                if (rs.getLong(1) + 1L != rs.getLong(2)) {
                    throw new Exception("Invalid result retrieved");
                }
                ++rsSize;
            }
        }
        if (rsSize != expRsSize) {
            throw new Exception("Invalid result set size [actual=" + rsSize + ", expected=" + expRsSize + ']');
        }
        return true;
    }
}

