/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.yardstick.IgniteBenchmarkArguments;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.jetbrains.annotations.NotNull;
import org.yardstickframework.BenchmarkUtils;

public class Loader
implements IgniteClosure<Integer, Integer> {
    private AtomicBoolean loaded = new AtomicBoolean();
    private IgniteCache<Integer, SampleValue> cache;
    private IgniteBenchmarkArguments args;
    private Ignite ignite;

    Loader(IgniteCache<Integer, SampleValue> cache, IgniteBenchmarkArguments args, Ignite ignite) {
        this.cache = cache;
        this.args = args;
        this.ignite = ignite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer apply(Integer integer) {
        DataRegionConfiguration[] arr;
        CacheConfiguration cc = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
        String dataRegName = cc.getDataRegionName();
        BenchmarkUtils.println((String)("Data region name = " + dataRegName));
        DataStorageConfiguration dataStorCfg = this.ignite.configuration().getDataStorageConfiguration();
        int pageSize = dataStorCfg.getPageSize();
        BenchmarkUtils.println((String)("Page size = " + pageSize));
        DataRegionConfiguration dataRegCfg = null;
        for (DataRegionConfiguration cfg : arr = this.ignite.configuration().getDataStorageConfiguration().getDataRegionConfigurations()) {
            if (!cfg.getName().equals(dataRegName)) continue;
            dataRegCfg = cfg;
        }
        if (dataRegCfg == null) {
            BenchmarkUtils.println((String)String.format("Failed to get data region configuration for cache %s", this.cache.getName()));
            return null;
        }
        long maxSize = dataRegCfg.getMaxSize();
        BenchmarkUtils.println((String)("Max size = " + maxSize));
        long initSize = dataRegCfg.getInitialSize();
        if (maxSize != initSize) {
            BenchmarkUtils.println((String)"Initial data region size must be equal to max size!");
        }
        long pageNum = maxSize / (long)pageSize;
        BenchmarkUtils.println((String)("Pages in data region: " + pageNum));
        int cnt = 0;
        final long pagesToLoad = pageNum * (long)this.args.preloadDataRegionMult();
        IgniteEx igniteEx = (IgniteEx)this.ignite;
        try {
            final DataRegionMetricsImpl impl = igniteEx.context().cache().context().database().dataRegion(dataRegName).memoryMetrics();
            impl.enableMetrics();
            BenchmarkUtils.println((String)("Initial allocated pages = " + impl.getTotalAllocatedPages()));
            ExecutorService serv = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(@NotNull Runnable r) {
                    return new Thread(r, "Preload checker");
                }
            });
            Future<?> checkFut = serv.submit(new Runnable(){

                @Override
                public void run() {
                    while (!Loader.this.loaded.get()) {
                        if (impl.getTotalAllocatedPages() >= pagesToLoad) {
                            Loader.this.loaded.getAndSet(true);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            BenchmarkUtils.error((String)"Was interrupted while waiting before next check.", (Throwable)e);
                        }
                    }
                }
            });
            try (IgniteDataStreamer streamer = this.ignite.dataStreamer(this.cache.getName());){
                while (!this.loaded.get()) {
                    streamer.addData((Object)cnt++, (Object)new SampleValue());
                    if (cnt % 1000000 != 0) continue;
                    long allocPages = impl.getTotalAllocatedPages();
                    BenchmarkUtils.println((String)("Load count = " + cnt));
                    BenchmarkUtils.println((String)("Allocated pages = " + allocPages));
                }
            }
            catch (Exception e) {
                BenchmarkUtils.error((String)"Failed to load data.", (Throwable)e);
            }
            try {
                checkFut.get();
            }
            catch (InterruptedException | ExecutionException e) {
                BenchmarkUtils.error((String)"Failed to check loading.", (Throwable)e);
            }
            finally {
                serv.shutdown();
            }
            impl.disableMetrics();
            BenchmarkUtils.println((String)("Objects loaded = " + cnt));
            BenchmarkUtils.println((String)("Total allocated pages = " + impl.getTotalAllocatedPages()));
        }
        catch (IgniteCheckedException e) {
            BenchmarkUtils.error((String)"Failed to load data.", (Throwable)e);
        }
        return cnt;
    }
}

