/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sink.flink;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.internal.util.typedef.internal.A;

public class IgniteSink<IN>
extends RichSinkFunction<IN> {
    private static final long DFLT_FLUSH_FREQ = 10000L;
    private transient IgniteLogger log;
    private long autoFlushFrequency = 10000L;
    private boolean allowOverwrite = false;
    private volatile boolean stopped = true;
    protected transient Ignite ignite;
    protected transient IgniteDataStreamer streamer;
    protected final String igniteCfgFile;
    protected final String cacheName;

    public String getCacheName() {
        return this.cacheName;
    }

    public String getIgniteConfigFile() {
        return this.igniteCfgFile;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public long getAutoFlushFrequency() {
        return this.autoFlushFrequency;
    }

    public void setAutoFlushFrequency(long autoFlushFrequency) {
        this.autoFlushFrequency = autoFlushFrequency;
    }

    public boolean getAllowOverwrite() {
        return this.allowOverwrite;
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public IgniteSink(String cacheName, String igniteCfgFile) {
        this.cacheName = cacheName;
        this.igniteCfgFile = igniteCfgFile;
    }

    public void open(Configuration parameter) {
        A.notNull((Object)this.igniteCfgFile, (String)"Ignite config file");
        A.notNull((Object)this.cacheName, (String)"Cache name");
        try {
            this.ignite = Ignition.ignite();
        }
        catch (IgniteIllegalStateException e) {
            this.ignite = Ignition.start((String)this.igniteCfgFile);
        }
        this.ignite.getOrCreateCache(this.cacheName);
        this.log = this.ignite.log();
        this.streamer = this.ignite.dataStreamer(this.cacheName);
        this.streamer.autoFlushFrequency(this.autoFlushFrequency);
        this.streamer.allowOverwrite(this.allowOverwrite);
        this.stopped = false;
    }

    public void close() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.streamer.close();
    }

    public void invoke(IN in) {
        try {
            if (!(in instanceof Map)) {
                throw new IgniteException("Map as a streamer input is expected!");
            }
            this.streamer.addData((Map)in);
        }
        catch (Exception e) {
            this.log.error("Error while processing IN of " + this.cacheName, (Throwable)e);
        }
    }
}

