/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.boosting;

import org.apache.ignite.ml.composition.boosting.GDBLearningStrategy;
import org.apache.ignite.ml.composition.boosting.GDBRegressionTrainer;
import org.apache.ignite.ml.tree.DecisionTreeRegressionTrainer;
import org.apache.ignite.ml.tree.boosting.GDBOnTreesLearningStrategy;
import org.jetbrains.annotations.NotNull;

public class GDBRegressionOnTreesTrainer
extends GDBRegressionTrainer {
    private int maxDepth;
    private double minImpurityDecrease;
    private boolean usingIdx = true;

    public GDBRegressionOnTreesTrainer(double gradStepSize, Integer cntOfIterations, int maxDepth, double minImpurityDecrease) {
        super(gradStepSize, cntOfIterations);
        this.maxDepth = maxDepth;
        this.minImpurityDecrease = minImpurityDecrease;
    }

    @NotNull
    protected DecisionTreeRegressionTrainer buildBaseModelTrainer() {
        return new DecisionTreeRegressionTrainer(this.maxDepth, this.minImpurityDecrease).withUsingIdx(this.usingIdx);
    }

    public GDBRegressionOnTreesTrainer withUsingIdx(boolean usingIdx) {
        this.usingIdx = usingIdx;
        return this;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public GDBRegressionOnTreesTrainer setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public double getMinImpurityDecrease() {
        return this.minImpurityDecrease;
    }

    public GDBRegressionOnTreesTrainer setMinImpurityDecrease(double minImpurityDecrease) {
        this.minImpurityDecrease = minImpurityDecrease;
        return this;
    }

    public boolean isUsingIdx() {
        return this.usingIdx;
    }

    @Override
    protected GDBLearningStrategy getLearningStrategy() {
        return new GDBOnTreesLearningStrategy(this.usingIdx);
    }
}

