/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.trainers;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class DatasetTrainer<M extends Model, L> {
    protected LearningEnvironment environment = LearningEnvironment.DEFAULT;

    public abstract <K, V> M fit(DatasetBuilder<K, V> var1, IgniteBiFunction<K, V, Vector> var2, IgniteBiFunction<K, V, L> var3);

    public <K, V> M update(M mdl, DatasetBuilder<K, V> datasetBuilder, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        if (mdl != null) {
            if (this.checkState(mdl)) {
                return this.updateModel(mdl, datasetBuilder, featureExtractor, lbExtractor);
            }
            this.environment.logger(this.getClass()).log(MLLogger.VerboseLevel.HIGH, "Model cannot be updated because of initial state of it doesn't corresponds to trainer parameters", new Object[0]);
        }
        return this.fit(datasetBuilder, featureExtractor, lbExtractor);
    }

    protected abstract boolean checkState(M var1);

    @NotNull
    protected M getLastTrainedModelOrThrowEmptyDatasetException(M lastTrainedMdl) {
        String msg = "Cannot train model on empty dataset";
        if (lastTrainedMdl != null) {
            this.environment.logger(this.getClass()).log(MLLogger.VerboseLevel.HIGH, msg, new Object[0]);
            return lastTrainedMdl;
        }
        throw new EmptyDatasetException();
    }

    protected abstract <K, V> M updateModel(M var1, DatasetBuilder<K, V> var2, IgniteBiFunction<K, V, Vector> var3, IgniteBiFunction<K, V, L> var4);

    public <K, V> M fit(Ignite ignite, IgniteCache<K, V> cache, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.fit(new CacheBasedDatasetBuilder<K, V>(ignite, cache), featureExtractor, lbExtractor);
    }

    public <K, V> M update(M mdl, Ignite ignite, IgniteCache<K, V> cache, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.update(mdl, new CacheBasedDatasetBuilder<K, V>(ignite, cache), featureExtractor, lbExtractor);
    }

    public <K, V> M fit(Ignite ignite, IgniteCache<K, V> cache, IgniteBiPredicate<K, V> filter, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.fit(new CacheBasedDatasetBuilder<K, V>(ignite, cache, filter), featureExtractor, lbExtractor);
    }

    public <K, V> M update(M mdl, Ignite ignite, IgniteCache<K, V> cache, IgniteBiPredicate<K, V> filter, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.update(mdl, new CacheBasedDatasetBuilder<K, V>(ignite, cache, filter), featureExtractor, lbExtractor);
    }

    public <K, V> M fit(Map<K, V> data, int parts, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.fit(new LocalDatasetBuilder<K, V>(data, parts), featureExtractor, lbExtractor);
    }

    public <K, V> M update(M mdl, Map<K, V> data, int parts, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.update(mdl, new LocalDatasetBuilder<K, V>(data, parts), featureExtractor, lbExtractor);
    }

    public <K, V> M fit(Map<K, V> data, IgniteBiPredicate<K, V> filter, int parts, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.fit(new LocalDatasetBuilder<K, V>(data, filter, parts), featureExtractor, lbExtractor);
    }

    public <K, V> M update(M mdl, Map<K, V> data, IgniteBiPredicate<K, V> filter, int parts, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor) {
        return this.update(mdl, new LocalDatasetBuilder<K, V>(data, filter, parts), featureExtractor, lbExtractor);
    }

    public void setEnvironment(LearningEnvironment environment) {
        this.environment = environment;
    }

    public static class EmptyDatasetException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 6914650522523293521L;

        public EmptyDatasetException() {
            super("Cannot train model on empty dataset");
        }
    }
}

