/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.svm;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class SVMLinearBinaryClassificationModel
implements Model<Vector, Double>,
Exportable<SVMLinearBinaryClassificationModel>,
Serializable {
    private static final long serialVersionUID = -996984622291440226L;
    private boolean isKeepingRawLabels = false;
    private double threshold = 0.5;
    private Vector weights;
    private double intercept;

    public SVMLinearBinaryClassificationModel(Vector weights, double intercept) {
        this.weights = weights;
        this.intercept = intercept;
    }

    public SVMLinearBinaryClassificationModel withRawLabels(boolean isKeepingRawLabels) {
        this.isKeepingRawLabels = isKeepingRawLabels;
        return this;
    }

    public SVMLinearBinaryClassificationModel withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public SVMLinearBinaryClassificationModel withWeights(Vector weights) {
        this.weights = weights;
        return this;
    }

    public SVMLinearBinaryClassificationModel withIntercept(double intercept) {
        this.intercept = intercept;
        return this;
    }

    @Override
    public Double apply(Vector input) {
        double res = input.dot(this.weights) + this.intercept;
        if (this.isKeepingRawLabels) {
            return res;
        }
        return res - this.threshold > 0.0 ? 1.0 : 0.0;
    }

    public boolean isKeepingRawLabels() {
        return this.isKeepingRawLabels;
    }

    public double threshold() {
        return this.threshold;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public <P> void saveModel(Exporter<SVMLinearBinaryClassificationModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SVMLinearBinaryClassificationModel mdl = (SVMLinearBinaryClassificationModel)o;
        return Double.compare(mdl.intercept, this.intercept) == 0 && Double.compare(mdl.threshold, this.threshold) == 0 && Boolean.compare(mdl.isKeepingRawLabels, this.isKeepingRawLabels) == 0 && Objects.equals(this.weights, mdl.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights, this.intercept, this.isKeepingRawLabels, this.threshold);
    }

    public String toString() {
        if (this.weights.size() < 20) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.weights.size(); ++i) {
                double nextItem = i == this.weights.size() - 1 ? this.intercept : this.weights.get(i + 1);
                builder.append(String.format("%.4f", Math.abs(this.weights.get(i)))).append("*x").append(i).append(nextItem > 0.0 ? " + " : " - ");
            }
            builder.append(String.format("%.4f", Math.abs(this.intercept)));
            return builder.toString();
        }
        return "SVMModel [weights=" + this.weights + ", intercept=" + this.intercept + ']';
    }

    @Override
    public String toString(boolean pretty) {
        return this.toString();
    }
}

