/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures.partition;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.LabeledVectorSet;

public class LabeledDatasetPartitionDataBuilderOnHeap<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, LabeledVectorSet<Double, LabeledVector>> {
    private static final long serialVersionUID = -7820760153954269227L;
    private final IgniteBiFunction<K, V, Vector> xExtractor;
    private final IgniteBiFunction<K, V, Double> yExtractor;

    public LabeledDatasetPartitionDataBuilderOnHeap(IgniteBiFunction<K, V, Vector> xExtractor, IgniteBiFunction<K, V, Double> yExtractor) {
        this.xExtractor = xExtractor;
        this.yExtractor = yExtractor;
    }

    @Override
    public LabeledVectorSet<Double, LabeledVector> build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        int xCols = -1;
        double[][] x = null;
        double[] y = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            Vector row = (Vector)this.xExtractor.apply(entry.getKey(), entry.getValue());
            if (xCols < 0) {
                xCols = row.size();
                x = new double[Math.toIntExact(upstreamDataSize)][xCols];
            } else assert (row.size() == xCols) : "X extractor must return exactly " + xCols + " columns";
            x[ptr] = row.asArray();
            y[ptr] = (Double)this.yExtractor.apply(entry.getKey(), entry.getValue());
            ++ptr;
        }
        return new LabeledVectorSet<Double, LabeledVector>(x, y);
    }
}

