/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.evaluator;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.selection.scoring.cursor.CacheBasedLabelPairCursor;
import org.apache.ignite.ml.selection.scoring.metric.Accuracy;

public class Evaluator {
    public static <L, K, V> double evaluate(IgniteCache<K, V> dataCache, Model<Vector, L> mdl, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor, Accuracy<L> metric) {
        double metricRes;
        try (CacheBasedLabelPairCursor<L, K, V> cursor = new CacheBasedLabelPairCursor<L, K, V>(dataCache, featureExtractor, lbExtractor, mdl);){
            metricRes = metric.score(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricRes;
    }

    public static <L, K, V> double evaluate(IgniteCache<K, V> dataCache, IgniteBiPredicate<K, V> filter, Model<Vector, L> mdl, IgniteBiFunction<K, V, Vector> featureExtractor, IgniteBiFunction<K, V, L> lbExtractor, Accuracy<L> metric) {
        double metricRes;
        try (CacheBasedLabelPairCursor<L, K, V> cursor = new CacheBasedLabelPairCursor<L, K, V>(dataCache, filter, featureExtractor, lbExtractor, mdl);){
            metricRes = metric.score(cursor.iterator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metricRes;
    }
}

