/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.imputing;

import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class ImputerPreprocessor<K, V>
implements IgniteBiFunction<K, V, Vector> {
    private static final long serialVersionUID = 6887800576392623469L;
    private final Vector imputingValues;
    private final IgniteBiFunction<K, V, Vector> basePreprocessor;

    public ImputerPreprocessor(Vector imputingValues, IgniteBiFunction<K, V, Vector> basePreprocessor) {
        this.imputingValues = imputingValues;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public Vector apply(K k, V v) {
        Vector res = (Vector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.imputingValues.size());
        for (int i = 0; i < res.size(); ++i) {
            if (!Double.valueOf(res.get(i)).equals(Double.NaN)) continue;
            res.set(i, this.imputingValues.get(i));
        }
        return res;
    }
}

