/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.encoding.stringencoder;

import java.util.Map;
import java.util.Set;
import org.apache.ignite.ml.math.exceptions.preprocessing.UnknownCategorialFeatureValue;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.preprocessing.encoding.EncoderPreprocessor;

public class StringEncoderPreprocessor<K, V>
extends EncoderPreprocessor<K, V> {
    protected static final long serialVersionUID = 6237712226382623488L;

    public StringEncoderPreprocessor(Map<String, Integer>[] encodingValues, IgniteBiFunction<K, V, Object[]> basePreprocessor, Set<Integer> handledIndices) {
        super(encodingValues, basePreprocessor, handledIndices);
    }

    @Override
    public Vector apply(K k, V v) {
        Object[] tmp = (Object[])this.basePreprocessor.apply(k, v);
        double[] res = new double[tmp.length];
        for (int i = 0; i < res.length; ++i) {
            Object tmpObj = tmp[i];
            if (this.handledIndices.contains(i)) {
                if (tmpObj.equals(Double.NaN) && this.encodingValues[i].containsKey("")) {
                    res[i] = ((Integer)this.encodingValues[i].get("")).intValue();
                    continue;
                }
                if (this.encodingValues[i].containsKey(tmpObj)) {
                    res[i] = ((Integer)this.encodingValues[i].get(tmpObj)).intValue();
                    continue;
                }
                throw new UnknownCategorialFeatureValue(tmpObj.toString());
            }
            res[i] = (Double)tmpObj;
        }
        return VectorUtils.of(res);
    }
}

