/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.binarization;

import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class BinarizationPreprocessor<K, V>
implements IgniteBiFunction<K, V, Vector> {
    private static final long serialVersionUID = 6877811577892621239L;
    private final double threshold;
    private final IgniteBiFunction<K, V, Vector> basePreprocessor;

    public BinarizationPreprocessor(double threshold, IgniteBiFunction<K, V, Vector> basePreprocessor) {
        this.threshold = threshold;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public Vector apply(K k, V v) {
        Vector res = (Vector)this.basePreprocessor.apply(k, v);
        for (int i = 0; i < res.size(); ++i) {
            if (res.get(i) > this.threshold) {
                res.set(i, 1.0);
                continue;
            }
            res.set(i, 0.0);
        }
        return res;
    }

    public double getThreshold() {
        return this.threshold;
    }
}

