/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.storage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class VectorViewStorage
implements VectorStorage {
    private VectorStorage sto;
    private int off;
    private int len;

    public VectorViewStorage() {
    }

    public VectorViewStorage(VectorStorage sto, int off, int len) {
        assert (sto != null);
        assert (off >= 0);
        assert (len > 0);
        this.sto = sto;
        this.off = off;
        this.len = len;
    }

    public VectorStorage delegate() {
        return this.sto;
    }

    public int offset() {
        return this.off;
    }

    public int length() {
        return this.len;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public double get(int i) {
        return this.sto.get(this.off + i);
    }

    @Override
    public void set(int i, double v) {
        this.sto.set(this.off + i, v);
    }

    @Override
    public double[] data() {
        return this.sto.data();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.sto.isSequentialAccess();
    }

    @Override
    public boolean isDense() {
        return this.sto.isDense();
    }

    @Override
    public boolean isRandomAccess() {
        return this.sto.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.sto.isDistributed();
    }

    @Override
    public boolean isArrayBased() {
        return this.sto.isArrayBased();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sto);
        out.writeInt(this.off);
        out.writeInt(this.len);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sto = (VectorStorage)in.readObject();
        this.off = in.readInt();
        this.len = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorViewStorage that = (VectorViewStorage)o;
        return this.len == that.len && this.off == that.off && (this.sto != null ? this.sto.equals(that.sto) : that.sto == null);
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.off;
        res = res * 37 + this.len;
        res = res * 37 + this.sto.hashCode();
        return res;
    }
}

