/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector;

import java.io.Externalizable;
import java.util.Spliterator;
import java.util.function.IntToDoubleFunction;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.Destroyable;
import org.apache.ignite.ml.math.MetaAttributes;
import org.apache.ignite.ml.math.StorageOpsMetrics;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteIntDoubleToDoubleBiFunction;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public interface Vector
extends MetaAttributes,
Externalizable,
StorageOpsMetrics,
Destroyable {
    public int size();

    public Vector copy();

    public Iterable<Element> all();

    public Iterable<Element> nonZeroes();

    public Spliterator<Double> allSpliterator();

    public Spliterator<Double> nonZeroSpliterator();

    public Vector sort();

    public Element getElement(int var1);

    public Vector assign(double var1);

    public Vector assign(double[] var1);

    public Vector assign(Vector var1);

    public Vector assign(IntToDoubleFunction var1);

    public Vector map(IgniteDoubleFunction<Double> var1);

    public Vector map(Vector var1, IgniteBiFunction<Double, Double, Double> var2);

    public Vector map(IgniteBiFunction<Double, Double, Double> var1, double var2);

    public Vector divide(double var1);

    public double dot(Vector var1);

    public double get(int var1);

    public double getX(int var1);

    public Vector like(int var1);

    public Matrix likeMatrix(int var1, int var2);

    public Matrix toMatrix(boolean var1);

    public Matrix toMatrixPlusOne(boolean var1, double var2);

    public Vector minus(Vector var1);

    public Vector normalize();

    public Vector normalize(double var1);

    public Vector logNormalize();

    public Vector logNormalize(double var1);

    public double kNorm(double var1);

    public double minValue();

    public double maxValue();

    public Element minElement();

    public Element maxElement();

    public Vector plus(double var1);

    public Vector plus(Vector var1);

    public Vector set(int var1, double var2);

    public Vector setX(int var1, double var2);

    public Vector incrementX(int var1, double var2);

    public Vector increment(int var1, double var2);

    public int nonZeroElements();

    public Vector times(double var1);

    public Vector times(Vector var1);

    public Vector viewPart(int var1, int var2);

    public VectorStorage getStorage();

    public double sum();

    public Matrix cross(Vector var1);

    public <T> T foldMap(IgniteBiFunction<T, Double, T> var1, IgniteDoubleFunction<Double> var2, T var3);

    public <T> T foldMap(Vector var1, IgniteBiFunction<T, Double, T> var2, IgniteBiFunction<Double, Double, Double> var3, T var4);

    public double getLengthSquared();

    public double getDistanceSquared(Vector var1);

    public IgniteUuid guid();

    public void compute(int var1, IgniteIntDoubleToDoubleBiFunction var2);

    default public double[] asArray() {
        return this.getStorage().data();
    }

    public static interface Element {
        public double get();

        public int index();

        public void set(double var1);
    }
}

