/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn.ann;

import java.io.Serializable;
import org.apache.ignite.ml.knn.ann.ANNClassificationTrainer;
import org.apache.ignite.ml.knn.ann.ProbableLabel;
import org.apache.ignite.ml.knn.classification.KNNModelFormat;
import org.apache.ignite.ml.knn.classification.NNStrategy;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.LabeledVectorSet;

public class ANNModelFormat
extends KNNModelFormat
implements Serializable {
    private final ANNClassificationTrainer.CentroidStat candidatesStat;
    private LabeledVectorSet<ProbableLabel, LabeledVector> candidates;

    public ANNModelFormat(int k, DistanceMeasure measure, NNStrategy stgy, LabeledVectorSet<ProbableLabel, LabeledVector> candidates, ANNClassificationTrainer.CentroidStat candidatesStat) {
        this.k = k;
        this.distanceMeasure = measure;
        this.stgy = stgy;
        this.candidates = candidates;
        this.candidatesStat = candidatesStat;
    }

    public LabeledVectorSet<ProbableLabel, LabeledVector> getCandidates() {
        return this.candidates;
    }

    @Override
    public int hashCode() {
        int res = 1;
        res = res * 37 + this.k;
        res = res * 37 + this.distanceMeasure.hashCode();
        res = res * 37 + this.stgy.hashCode();
        res = res * 37 + this.candidates.hashCode();
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ANNModelFormat that = (ANNModelFormat)obj;
        return this.k == that.k && this.distanceMeasure.equals(that.distanceMeasure) && this.stgy.equals((Object)that.stgy) && this.candidates.equals(that.candidates);
    }
}

